/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSShowTypeInfoAction
extends ExpressionTypeProvider<PsiElement> {
    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getInformationHint"));
        }
        JSType type = JSShowTypeInfoAction.getTypeForDocumentation(element);
        String presentableType = JSTypeUtils.getNonEmptyPresentableType(type, (JSElement)element);
        String string = XmlStringUtil.escapeString((String)JSBundle.message((String)"js.show.type.info.action.message", (Object[])new Object[]{presentableType}));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getInformationHint"));
        }
        return string;
    }

    @Nullable
    public static JSType getTypeForDocumentation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getTypeForDocumentation"));
        }
        JSType type = null;
        if (element instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)element);
        } else if (element instanceof JSParameter) {
            type = ((JSParameter)element).getType();
            if (type == null && ((JSParameter)element).getTypeElement() == null) {
                type = JSContextTypeEvaluator.getParameterType((JSParameter)element, new JSEvaluateContext(element.getContainingFile()));
            }
        } else if (element instanceof JSVariable && (type = ((JSVariable)element).getType()) == null) {
            JSTypeEvaluationResult result = JSTypeEvaluator.getElementType(element);
            type = result != null ? result.getType() : null;
        }
        return type;
    }

    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getErrorHint"));
        }
        return string;
    }

    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getExpressionsAt"));
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(o -> o instanceof JSExpression && (!(o instanceof JSFunctionExpression) || JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)o)) != null) || o instanceof JSVariable).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction", "getExpressionsAt"));
        }
        return list;
    }
}

