/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.bower.BowerCommandRun;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerCommandLineUtil {
    private static final Logger LOG = Logger.getInstance(BowerCommandLineUtil.class);
    private static final NullableLazyValue<File> TEMP_DIR = NullableLazyValue.createValue(() -> {
        try {
            return FileUtil.createTempDirectory((String)"jetbrains-intellij-bower", null);
        }
        catch (IOException e) {
            LOG.warn("Cannot create temp dir", (Throwable)e);
            return null;
        }
    });

    private BowerCommandLineUtil() {
    }

    @NotNull
    public static String getBowerExecutableFilename() {
        String string = SystemInfo.isWindows ? "bower.cmd" : "bower";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "getBowerExecutableFilename"));
        }
        return string;
    }

    @NotNull
    public static ProcessOutput runBowerCommand(@Nullable ProgressIndicator indicator, @NotNull BowerSettings settings, String ... commands) throws ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "runBowerCommand"));
        }
        BowerCommandRun bowerCommandRun = BowerCommandLineUtil.startBowerCommand(settings, commands);
        ProcessOutput processOutput = bowerCommandRun.captureOutput(indicator, TimeUnit.MINUTES.toMillis(10L));
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "runBowerCommand"));
        }
        return processOutput;
    }

    @NotNull
    public static BowerCommandRun startBowerCommand(@NotNull BowerSettings settings, String ... commands) throws ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "startBowerCommand"));
        }
        GeneralCommandLine commandLine = BowerCommandLineUtil.createCommandLine(settings);
        commandLine.addParameters(commands);
        LOG.info("Running bower command: " + commandLine.getCommandLineString());
        BowerCommandRun bowerCommandRun = new BowerCommandRun((OSProcessHandler)new KillableColoredProcessHandler(commandLine));
        if (bowerCommandRun == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "startBowerCommand"));
        }
        return bowerCommandRun;
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull BowerSettings settings) throws ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "createCommandLine"));
        }
        NodeJsInterpreter interpreter = settings.getInterpreter();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        File workingDir = BowerCommandLineUtil.getWorkingDir(settings);
        if (workingDir != null) {
            commandLine.setWorkDirectory(workingDir);
        } else {
            LOG.info("Working directory not specified");
        }
        String bowerExecutablePath = settings.getBowerExecutablePath();
        if (StringUtil.isEmptyOrSpaces((String)bowerExecutablePath) || !new File(bowerExecutablePath).isFile()) {
            throw new ExecutionException("Illegal bower executable file: " + bowerExecutablePath);
        }
        if (SystemInfo.isWindows) {
            commandLine.setExePath(bowerExecutablePath);
        } else {
            commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
            commandLine.addParameter(bowerExecutablePath);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @Nullable
    private static File getWorkingDir(@NotNull BowerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "getWorkingDir"));
        }
        File bowerConfigFile = new File(settings.getBowerJsonPath());
        if (bowerConfigFile.isFile()) {
            return bowerConfigFile.getParentFile();
        }
        return (File)TEMP_DIR.getValue();
    }
}

