/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.execution.ExecutionException;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.bower.BowerPackageBasicInfo;
import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerPackageUtil;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerSettingsManager;
import com.intellij.lang.javascript.bower.browsePackages.BowerPackageSearcher;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(BowerCompletionContributor.class);
    private static final List<String> DEPENDENCIES_NAMES = ContainerUtil.list((Object[])new String[]{"dependencies", "devDependencies"});
    private static final Map<String, List<String>> ourVersionCache = ContainerUtil.createConcurrentSoftMap();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "fillCompletionVariants"));
        }
        JsonFile packageJson = BowerPackageUtil.getContainingBowerJsonFile((PsiElement)parameters.getOriginalFile());
        if (packageJson != null) {
            BowerCompletionContributor.completeDependencies(parameters, result);
        }
    }

    @Nullable
    private static JsonProperty findEnclosingDependenciesProperty(@NotNull PsiElement element) {
        JsonProperty dependenciesProperty;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "findEnclosingDependenciesProperty"));
        }
        JsonObject obj = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class, (boolean)false);
        if (obj != null && (dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class)) != null && DEPENDENCIES_NAMES.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty)) {
            return dependenciesProperty;
        }
        return null;
    }

    private static void completeDependencies(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependencies"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependencies"));
        }
        PsiElement element = (PsiElement)ObjectUtils.notNull((Object)parameters.getOriginalPosition(), (Object)parameters.getPosition());
        JsonProperty dependenciesProperty = BowerCompletionContributor.findEnclosingDependenciesProperty(element);
        if (dependenciesProperty != null) {
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh(new LookupElementWeigher("priority"){

                @NotNull
                public Double weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/bower/BowerCompletionContributor$1", "weigh"));
                    }
                    PrioritizedLookupElement ple = (PrioritizedLookupElement)ObjectUtils.tryCast((Object)element, PrioritizedLookupElement.class);
                    Double d = ple != null ? ple.getPriority() : 0.0;
                    if (d == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCompletionContributor$1", "weigh"));
                    }
                    return d;
                }
            });
            result = result.withRelevanceSorter(sorter);
            JsonProperty parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
            if (parentProperty == dependenciesProperty) {
                parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), JsonProperty.class);
            }
            if (parentProperty != null) {
                JsonValue nameElement = parentProperty.getNameElement();
                if (nameElement.getTextRange().containsOffset(parameters.getOffset())) {
                    int prefixLength = parameters.getOffset() - nameElement.getTextRange().getStartOffset();
                    String prefix = StringUtil.unquoteString((String)nameElement.getText().substring(0, prefixLength));
                    prefix = StringUtil.trimStart((String)prefix, (String)"\"");
                    BowerCompletionContributor.completeDependenciesNames(parameters, result.withPrefixMatcher(prefix), prefix, parentProperty);
                } else {
                    result = result.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(result.getPrefixMatcher().getPrefix()));
                    BowerCompletionContributor.completeDependenciesVersions(parameters, result, parentProperty);
                }
            }
        }
    }

    private static void completeDependenciesNames(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String packageNamePrefix, @NotNull JsonProperty property) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesNames"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesNames"));
        }
        if (packageNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNamePrefix", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesNames"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesNames"));
        }
        Set alreadyUsedNames = JsonPsiUtil.getOtherSiblingPropertyNames((JsonProperty)property);
        BowerPackageSearcher searcher = BowerPackageSearcher.getInstance();
        List<BowerPackageBasicInfo> popularPackages = searcher.findPopularPackagesByPrefix(packageNamePrefix, 10, (Condition<BowerPackageBasicInfo>)((Condition)info -> !alreadyUsedNames.contains(info.getName())));
        AtomicInteger priority = new AtomicInteger(0);
        for (BowerPackageBasicInfo pkg : popularPackages) {
            BowerCompletionContributor.addPackageInfo(parameters, result, pkg, priority.getAndIncrement());
        }
        Set popularPackageNames = ContainerUtil.map2Set(popularPackages, BowerPackageBasicInfo::getName);
        try {
            searcher.findPackagesByPrefix(ProgressManager.getInstance().getProgressIndicator(), packageNamePrefix, 10, (Condition<BowerPackageBasicInfo>)((Condition)info -> !alreadyUsedNames.contains(info.getName()) && !popularPackageNames.contains(info.getName())), (Consumer<BowerPackageBasicInfo>)((Consumer)info -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "lambda$completeDependenciesNames$2"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "lambda$completeDependenciesNames$2"));
                }
                BowerCompletionContributor.addPackageInfo(parameters, result, info, priority.getAndIncrement());
            }));
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching '" + packageNamePrefix + "*' packages from registry cancelled");
        }
        catch (IOException e) {
            LOG.info("Cannot fetch '" + packageNamePrefix + "*' packages from registry", (Throwable)e);
        }
        result.restartCompletionOnAnyPrefixChange();
    }

    private static void addPackageInfo(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, final @NotNull BowerPackageBasicInfo info, int priority) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "addPackageInfo"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "addPackageInfo"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "addPackageInfo"));
        }
        String lookupString = info.getName() + " ";
        if (!BowerCompletionContributor.isInsideStringLiteral(parameters)) {
            lookupString = StringUtil.wrapWithDoubleQuote((String)lookupString);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)info, (String)lookupString);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(info.getName());
                presentation.setTypeGrayed(true);
                presentation.setTypeText(info.getDescription());
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(info.getName()));
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)priority));
    }

    private static boolean isInsideStringLiteral(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "isInsideStringLiteral"));
        }
        return parameters.getPosition().getParent() instanceof JsonStringLiteral;
    }

    private static void completeDependenciesVersions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull JsonProperty packageProperty) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesVersions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesVersions"));
        }
        if (packageProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageProperty", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "completeDependenciesVersions"));
        }
        String packageName = StringUtil.unquoteString((String)packageProperty.getNameElement().getText());
        List<String> versions = BowerCompletionContributor.getOrFetchVersions(packageName, packageProperty.getProject());
        int order = 0;
        for (String version : versions) {
            BowerCompletionContributor.addVersionCompletionItem(parameters, result, version, order++);
        }
    }

    @NotNull
    private static List<String> getOrFetchVersions(@NotNull String packageName, @NotNull Project project) {
        List<String> list;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getOrFetchVersions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getOrFetchVersions"));
        }
        List<String> versions = ourVersionCache.get(packageName);
        if (versions != null) {
            List<String> list2 = versions;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getOrFetchVersions"));
            }
            return list2;
        }
        BowerSettings settings = BowerSettingsManager.getInstance(project).getSettings();
        try {
            BowerPackageInfo info = BowerPackageUtil.loadPackageInfo(ProgressManager.getInstance().getProgressIndicator(), settings, packageName);
            versions = info.getVersions();
            ourVersionCache.put(packageName, versions);
            list = versions;
        }
        catch (ExecutionException e) {
            LOG.info("Cannot load versions for " + packageName + ": " + e.getMessage());
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getOrFetchVersions"));
            }
            return list3;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getOrFetchVersions"));
        }
        return list;
    }

    private static void addVersionCompletionItem(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String version, int order) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "addVersionCompletionItem"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "addVersionCompletionItem"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "addVersionCompletionItem"));
        }
        final String value = BowerCompletionContributor.getVersion(parameters, version);
        String lookupString = BowerCompletionContributor.isInsideStringLiteral(parameters) ? value : StringUtil.wrapWithDoubleQuote((String)value);
        LookupElementBuilder builder = LookupElementBuilder.create((Object)version, (String)lookupString);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(value);
                presentation.setTypeGrayed(true);
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(value));
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)order));
    }

    @NotNull
    private static String getVersion(@NotNull CompletionParameters parameters, @NotNull String version) {
        String text;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getVersion"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getVersion"));
        }
        PsiElement position = parameters.getOriginalPosition();
        if (position != null && ((text = StringUtil.unquoteString((String)position.getText())).startsWith("~") || text.startsWith("^"))) {
            String string = text.charAt(0) + version;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getVersion"));
            }
            return string;
        }
        String string = version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCompletionContributor", "getVersion"));
        }
        return string;
    }
}

