/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackageInfo {
    private static final Logger LOG = Logger.getInstance(BowerPackageInfo.class);
    private final List<String> myVersions;
    private final JsonObject myLatestContent;

    public BowerPackageInfo(@NotNull List<String> versions, @Nullable JsonObject latestContent) {
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/lang/javascript/bower/BowerPackageInfo", "<init>"));
        }
        this.myVersions = ImmutableList.copyOf(versions);
        this.myLatestContent = latestContent;
    }

    @NotNull
    public List<String> getVersions() {
        List<String> list = this.myVersions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackageInfo", "getVersions"));
        }
        return list;
    }

    @NotNull
    public String formatHtmlDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        buf.append("<head>").append("<style>").append(".line {padding-left:5px}").append("</style>").append("</head>");
        buf.append("<body class='line'>");
        buf.append("<pre>");
        if (this.myLatestContent != null) {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent("  ");
            jsonWriter.setLenient(true);
            try {
                Streams.write((JsonElement)this.myLatestContent, (JsonWriter)jsonWriter);
                buf.append(stringWriter.toString());
            }
            catch (IOException e) {
                LOG.warn("Can't stringify json", (Throwable)e);
                buf.append("Can't stringify json");
            }
        } else {
            buf.append("No information available");
        }
        buf.append("</pre>");
        buf.append("</body>");
        buf.append("</html>");
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackageInfo", "formatHtmlDescription"));
        }
        return string;
    }
}

