/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtExecutor;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JsbtTopHitProvider
implements SearchTopHitProvider {
    private static final String PATTERN_PREFIX = "run ";

    public void consumeTopHits(String pattern, Consumer<Object> collector, Project activeProject) {
        if (pattern == null || collector == null || activeProject == null) {
            return;
        }
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(activeProject);
            for (VirtualFile buildfile : fileManager.getBuildfiles()) {
                JsbtFileStructure structure = fileManager.getCachedStructure(buildfile);
                if (structure == null) continue;
                for (String taskName : structure.getTaskNames()) {
                    JsbtTopHitProvider.consumeTaskName(activeProject, service, structure, taskName, pattern, collector);
                }
            }
        }
    }

    private static void consumeTaskName(@NotNull Project project, @NotNull JsbtService service, @NotNull JsbtFileStructure structure, @NotNull String taskName, @NotNull String pattern, @NotNull Consumer<Object> collector) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "consumeTaskName"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "consumeTaskName"));
        }
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "consumeTaskName"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "consumeTaskName"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "consumeTaskName"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "consumeTaskName"));
        }
        if (JsbtTopHitProvider.match(pattern, taskName)) {
            collector.consume((Object)new JsbtTaskRunAction(project, service, new JsbtTaskSet(structure, Collections.singletonList(taskName))));
        }
    }

    private static boolean match(@NotNull String pattern, @NotNull String taskName) {
        String subPattern;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "match"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider", "match"));
        }
        if (StringUtil.startsWithIgnoreCase((String)pattern, (String)PATTERN_PREFIX) && StringUtil.startsWithIgnoreCase((String)taskName, (String)(subPattern = pattern.substring(PATTERN_PREFIX.length())))) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)taskName, (CharSequence)pattern);
    }

    private static class JsbtTaskRunAction
    extends DumbAwareAction {
        private final WeakReference<Project> myProject;
        private final JsbtService myService;
        private final JsbtTaskSet myTaskSet;

        protected JsbtTaskRunAction(@NotNull Project project, @NotNull JsbtService service, @NotNull JsbtTaskSet taskSet) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider$JsbtTaskRunAction", "<init>"));
            }
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider$JsbtTaskRunAction", "<init>"));
            }
            if (taskSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSet", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider$JsbtTaskRunAction", "<init>"));
            }
            super(null, null, service.getIcon());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText("Run '" + taskSet.getName() + "' " + service.getSearchEverywhereDescription(), false);
            this.myProject = new WeakReference<Project>(project);
            this.myService = service;
            this.myTaskSet = taskSet;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider$JsbtTaskRunAction", "update"));
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(project == this.myProject.get());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider$JsbtTaskRunAction", "actionPerformed"));
            }
            Project project = (Project)this.myProject.get();
            if (project != null && e.getProject() == project) {
                new JsbtExecutor(project, this.myService, this.myTaskSet).run();
            }
        }
    }
}

