/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageLevel
extends Enum<JSLanguageLevel> {
    public static final /* enum */ JSLanguageLevel JS_1_5 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_5, "js.language.version.combo.es3");
    public static final /* enum */ JSLanguageLevel ES5 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_5, "js.language.version.combo.es5");
    public static final /* enum */ JSLanguageLevel JS_1_6 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_6, "js.language.version.combo.js16");
    public static final /* enum */ JSLanguageLevel JS_1_7 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_7, "js.language.version.combo.js17");
    public static final /* enum */ JSLanguageLevel JS_1_8 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_8, "js.language.version.combo.js18");
    public static final /* enum */ JSLanguageLevel JS_1_8_5 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_8, "js.language.version.combo.js185");
    public static final /* enum */ JSLanguageLevel ES6 = new JSLanguageLevel(JavaScriptSupportLoader.ECMA_SCRIPT_6, "js.language.version.combo.es6");
    public static final /* enum */ JSLanguageLevel JSX = new JSLanguageLevel(JavaScriptSupportLoader.JSX_HARMONY, "js.language.version.combo.jsx");
    public static final /* enum */ JSLanguageLevel NASHORN = new JSLanguageLevel(JavaScriptSupportLoader.NASHORN_JS, "js.language.version.combo.nashorn");
    public static final /* enum */ JSLanguageLevel FLOW = new JSLanguageLevel(JavaScriptSupportLoader.FLOW_JS, "js.language.version.combo.flow");
    public static JSLanguageLevel DEFAULT;
    private final String myLabel;
    private final String myDescription;
    private final JSLanguageDialect myDialect;
    private static final /* synthetic */ JSLanguageLevel[] $VALUES;

    public static JSLanguageLevel[] values() {
        return (JSLanguageLevel[])$VALUES.clone();
    }

    public static JSLanguageLevel valueOf(String name) {
        return Enum.valueOf(JSLanguageLevel.class, name);
    }

    private JSLanguageLevel(JSLanguageDialect dialect, String resourceId) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/dialects/JSLanguageLevel", "<init>"));
        }
        this.myLabel = JSBundle.message((String)resourceId, (Object[])new Object[0]);
        this.myDescription = JSBundle.message((String)(resourceId + ".description"), (Object[])new Object[0]);
        this.myDialect = dialect;
    }

    public String toString() {
        return this.myLabel;
    }

    public String getId() {
        return super.toString();
    }

    @NotNull
    public JSLanguageDialect getDialect() {
        JSLanguageDialect jSLanguageDialect = this.myDialect;
        if (jSLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageLevel", "getDialect"));
        }
        return jSLanguageDialect;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public static JSLanguageLevel ofElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/dialects/JSLanguageLevel", "ofElement"));
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(element);
        if (dialect != null && dialect.getOptionHolder().isJavaScript()) {
            JSLanguageLevel configuredLevel = JSRootConfiguration.getInstance(element.getProject()).getLanguageLevel();
            for (JSLanguageLevel value : JSLanguageLevel.values()) {
                if (value.getDialect() != dialect || configuredLevel.isAtLeast(value)) continue;
                return value;
            }
            return configuredLevel;
        }
        return null;
    }

    public boolean isAtLeast(@NotNull JSLanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/lang/javascript/dialects/JSLanguageLevel", "isAtLeast"));
        }
        if (level == this) {
            return true;
        }
        switch (this) {
            case JS_1_5: {
                return false;
            }
            case ES5: {
                return JS_1_5.isAtLeast(level);
            }
            case JS_1_6: {
                return JS_1_5.isAtLeast(level);
            }
            case JS_1_7: {
                return JS_1_6.isAtLeast(level);
            }
            case JS_1_8: {
                return JS_1_7.isAtLeast(level);
            }
            case JS_1_8_5: {
                return JS_1_8.isAtLeast(level) || ES5.isAtLeast(level);
            }
            case ES6: {
                return ES5.isAtLeast(level);
            }
            case JSX: {
                return ES6.isAtLeast(level);
            }
            case NASHORN: {
                return ES5.isAtLeast(level);
            }
            case FLOW: {
                return ES6.isAtLeast(level);
            }
        }
        assert (false) : (Object)((Object)this) + " JSLanguageLevel case is missed";
        return false;
    }

    public boolean isES5Compatible() {
        return this.isAtLeast(ES5);
    }

    public boolean isES6Compatible() {
        return this.isAtLeast(ES6);
    }

    public boolean isXmlEnabled() {
        return this.getDialect().getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    @NotNull
    public static JSLanguageLevel ofId(@Nullable String id) {
        for (JSLanguageLevel level : JSLanguageLevel.values()) {
            if (!level.getId().equals(id)) continue;
            JSLanguageLevel jSLanguageLevel = level;
            if (jSLanguageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageLevel", "ofId"));
            }
            return jSLanguageLevel;
        }
        JSLanguageLevel jSLanguageLevel = DEFAULT;
        if (jSLanguageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageLevel", "ofId"));
        }
        return jSLanguageLevel;
    }

    static {
        $VALUES = new JSLanguageLevel[]{JS_1_5, ES5, JS_1_6, JS_1_7, JS_1_8, JS_1_8_5, ES6, JSX, NASHORN, FLOW};
        DEFAULT = ES5;
    }
}

