/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveProcessor
extends TypeScriptQualifiedItemProcessor<ResolveResultSink> {
    private List<JSType> myArgumentTypes;
    private final boolean myStrictTypeContext;
    private final boolean myIncompleteCode;
    private final boolean myStrictTypeContainerContext;
    private final JSCallExpression myCallParent;

    public TypeScriptResolveProcessor(String referenceName, PsiFile containingFile, JSExpression _place, boolean incompleteCode) {
        super(new ResolveResultSink((PsiElement)_place, referenceName), containingFile);
        JSReferenceExpression topRefExpression;
        this.myStrictTypeContext = _place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)_place);
        this.myIncompleteCode = incompleteCode;
        this.myStrictTypeContainerContext = !this.myStrictTypeContext ? (topRefExpression = TypeScriptResolveProcessor.getTopRefExpression((PsiElement)_place)) != null && JSResolveUtil.isExprInStrictTypeContext(topRefExpression) : false;
        PsiElement parent = this.place.getParent();
        while (parent instanceof JSParenthesizedExpressionImpl) {
            parent = parent.getParent();
        }
        this.myCallParent = parent instanceof JSCallExpression ? (JSCallExpression)parent : null;
    }

    @Nullable
    private static JSReferenceExpression getTopRefExpression(@Nullable PsiElement _place) {
        JSReferenceExpression result = null;
        while (_place instanceof JSReferenceExpression) {
            result = (JSReferenceExpression)_place;
            _place = _place.getParent();
        }
        return result;
    }

    @Override
    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        if (clazz instanceof TypeScriptModule) {
            String moduleName = ((TypeScriptModule)clazz).getName();
            String elementName = null;
            if (element instanceof PsiNamedElement) {
                elementName = ((PsiNamedElement)element).getName();
            } else if (element instanceof JSReferenceExpression) {
                elementName = ((JSReferenceExpression)element).getReferencedName();
            }
            if (Comparing.equal((String)elementName, (String)moduleName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        if (this.myStrictTypeContext || this.myStrictTypeContainerContext) {
            return TypeScriptPsiUtil.referencesNamedTypeContainer(specifier);
        }
        return super.isSpecifierAcceptable(specifier);
    }

    private PsiElement checkParameterTypes(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "checkParameterTypes"));
        }
        if (this.myCallParent == null) {
            return element;
        }
        if (this.myArgumentTypes == null) {
            this.myArgumentTypes = new ArrayList<JSType>();
            for (JSExpression expression : this.myCallParent.getArguments()) {
                this.myArgumentTypes.add(TypeScriptResolveProcessor.getExplicitTypeOrAny(expression, TypeScriptResolveProcessor.getParameterExpressionType(expression)));
            }
        }
        Map<String, JSType> genericArguments = TypeScriptResolveProcessor.addGenericArgumentsFromCall(element, (PsiElement)this.myCallParent, this.myGenericArguments);
        Ref functionRef = Ref.create((Object)element);
        String problem = TypeScriptResolveProcessor.checkParameterTypes((Ref<PsiElement>)functionRef, this.myArgumentTypes, genericArguments, this.myCallParent instanceof JSNewExpression);
        if (problem != null) {
            PsiElement elementToResolve = element;
            if (TypeScriptResolveProcessor.isOverloadImplementation(element) && !this.myIncompleteCode) {
                elementToResolve = (PsiElement)functionRef.get();
            }
            this.addPossibleCandidateResult(elementToResolve, problem);
            return null;
        }
        return this.myIncompleteCode ? element : (PsiElement)functionRef.get();
    }

    @Nullable
    private static JSType getParameterExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getParameterExpressionType"));
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        JSTypeEvaluationResult result = (JSTypeEvaluationResult)exprTypeRef.get();
        if (result == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
        if (results.size() <= 1) {
            return result.getType();
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = element.getType();
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isExplicitlyDeclared() && typeSource.isExplicitlyDeclared());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source, types);
    }

    @NotNull
    private static JSType getExplicitTypeOrAny(@NotNull JSExpression expression, @Nullable JSType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getExplicitTypeOrAny"));
        }
        JSAnyType jSAnyType = type == null || !type.getSource().isExplicitlyDeclared() ? JSAnyType.get((PsiElement)expression, false) : type;
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getExplicitTypeOrAny"));
        }
        return jSAnyType;
    }

    @Nullable
    public static Map<String, JSType> addGenericArgumentsFromCall(PsiElement resolveResult, PsiElement callExpression, @Nullable Map<String, JSType> genericArguments) {
        if (resolveResult instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameterList classTypeParameterList;
            JSClass clazz;
            TypeScriptTypeParameterList typeParameterList;
            if (genericArguments == null) {
                genericArguments = new THashMap();
            }
            if ((typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList()) != null) {
                TypeScriptTypeArgumentList list;
                TypeScriptTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
                JSTypeDeclaration[] typeArguments = null;
                if (callExpression instanceof JSCallExpression && (list = (TypeScriptTypeArgumentList)PsiTreeUtil.getChildOfType((PsiElement)callExpression, TypeScriptTypeArgumentList.class)) != null) {
                    typeArguments = list.getTypeArguments();
                }
                TypeScriptResolveProcessor.addExplicitGenericArguments((Map<String, JSType>)genericArguments, typeParameters, typeArguments);
            }
            if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (classTypeParameterList = ((TypeScriptTypeParameterListOwner)clazz).getTypeParameterList()) != null) {
                TypeScriptTypeArgumentList argumentList;
                JSTypeDeclaration[] typeArguments = null;
                if (callExpression instanceof TypeScriptNewExpression && (argumentList = ((TypeScriptNewExpression)callExpression).getTypeArguments()) != null) {
                    typeArguments = argumentList.getTypeArguments();
                }
                TypeScriptTypeParameter[] typeParameters = classTypeParameterList.getTypeParameters();
                TypeScriptResolveProcessor.addExplicitGenericArguments((Map<String, JSType>)genericArguments, typeParameters, typeArguments);
            }
        }
        return genericArguments;
    }

    private static void addExplicitGenericArguments(Map<String, JSType> genericArguments, TypeScriptTypeParameter[] typeParameters, JSTypeDeclaration[] typeArguments) {
        for (int i = 0; i < typeParameters.length; ++i) {
            JSType type = typeArguments != null && i < typeArguments.length ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArguments[i]) : null;
            String name = typeParameters[i].getName();
            if (name == null || genericArguments.containsKey(name) && type == null) continue;
            genericArguments.put(name, type);
        }
    }

    public static String checkParameterTypes(@NotNull Ref<PsiElement> functionRef, @Nullable List<JSType> argumentTypes, @Nullable Map<String, JSType> genericArguments, boolean inNewExpression) {
        if (functionRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionRef", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "checkParameterTypes"));
        }
        PsiElement function = (PsiElement)functionRef.get();
        JSParameterList parameterList = null;
        List<JSParameterTypeDecorator> parameterTypes = null;
        if (function instanceof TypeScriptCallSignature) {
            if (inNewExpression == ((TypeScriptCallSignature)function).isConstructor()) {
                parameterList = ((TypeScriptCallSignature)function).getParameterList();
            }
        } else if (function instanceof TypeScriptFunction) {
            List overloads = ((TypeScriptFunction)function).getOverloadDeclarations();
            String firstError = null;
            TypeScriptFunction firstOverload = null;
            for (TypeScriptFunction overload : overloads) {
                String latestError = TypeScriptResolveProcessor.checkParameterTypes(argumentTypes, genericArguments, overload.getParameterList(), null);
                if (latestError == null) {
                    functionRef.set((Object)overload);
                    return null;
                }
                if (firstError != null) continue;
                firstError = latestError;
                firstOverload = overload;
            }
            if (TypeScriptResolveProcessor.isOverloadImplementation(function)) {
                if (firstError != null) {
                    functionRef.set(firstOverload);
                }
                return firstError;
            }
            parameterList = ((TypeScriptFunction)function).getParameterList();
        } else if (function instanceof JSFunction) {
            parameterList = ((JSFunction)function).getParameterList();
        } else {
            if (function instanceof TypeScriptPropertySignature) {
                return TypeScriptResolveProcessor.checkArgumentsForTypeElement(functionRef, argumentTypes, genericArguments, inNewExpression, ((TypeScriptPropertySignature)function).getTypeDeclaration());
            }
            if (function instanceof TypeScriptInterface) {
                return TypeScriptResolveProcessor.checkArgumentsForTypeElement(functionRef, argumentTypes, genericArguments, inNewExpression, (JSTypeDeclaration)((TypeScriptInterface)function).getBody());
            }
            if (function instanceof TypeScriptVariable) {
                TypeScriptType typeElement = (TypeScriptType)((TypeScriptVariable)function).getTypeElement();
                if (typeElement != null) {
                    return TypeScriptResolveProcessor.checkArgumentsForTypeElement(functionRef, argumentTypes, genericArguments, inNewExpression, (JSTypeDeclaration)typeElement);
                }
                JSType type = JSTypeUtils.getValuableType(((TypeScriptVariable)function).getType());
                if (type instanceof JSFunctionTypeImpl) {
                    parameterTypes = ((JSFunctionTypeImpl)type).getParameters();
                }
            }
        }
        return TypeScriptResolveProcessor.checkParameterTypes(argumentTypes, genericArguments, parameterList, parameterTypes);
    }

    @Nullable
    public static JSFunction getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<JSFunction> functions) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getFunctionWithParameters"));
        }
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getFunctionWithParameters"));
        }
        List<JSType> argumentTypes = JSTypeUtils.getArgumentTypes(expression.getArgumentList());
        for (JSFunction constructor : functions) {
            if (TypeScriptResolveProcessor.checkParameterTypes(argumentTypes, null, constructor.getParameterList(), null) != null) continue;
            return constructor;
        }
        return null;
    }

    @Nullable
    public static String checkParameterTypes(@Nullable List<JSType> argumentTypes, @Nullable Map<String, JSType> genericArguments, @Nullable JSParameterList parameterList, @Nullable List<JSParameterTypeDecorator> parameterTypes) {
        if (parameterTypes == null && parameterList != null) {
            parameterTypes = new ArrayList<JSParameterTypeDecorator>();
            for (JSParameterListElement p : parameterList.getParameters()) {
                JSType parameterType = p.getType();
                if (genericArguments != null && parameterType != null) {
                    parameterType = JSTypeUtils.applyGenericArguments(parameterType, genericArguments);
                }
                JSParameterTypeDecoratorImpl typeDecorator = new JSParameterTypeDecoratorImpl(parameterType, p.isOptional(), p.isRest(), p.getTypeDecorator().isExplicitlyDeclared());
                parameterTypes.add(typeDecorator);
            }
        }
        if (parameterTypes == null) {
            return null;
        }
        ProcessingContext context = new ProcessingContext();
        context.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
        List<JSParameterTypeDecorator> arguments = JSTypeUtils.getParameterTypeDecorators(argumentTypes);
        return JSTypeUtils.areArgumentsAssignable(parameterTypes, arguments, context, false, true, true) ? null : "javascript.argument.types.mismatch";
    }

    private static String checkArgumentsForTypeElement(@NotNull Ref<PsiElement> functionRef, @Nullable List<JSType> argumentTypes, @Nullable Map<String, JSType> genericArguments, boolean inNewExpression, @Nullable JSTypeDeclaration type) {
        if (functionRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionRef", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "checkArgumentsForTypeElement"));
        }
        if (type instanceof TypeScriptObjectType) {
            TypeScriptTypeMember[] members = ((TypeScriptObjectType)type).getTypeMembers();
            boolean hasCallSignature = false;
            for (TypeScriptTypeMember member : members) {
                if (!(member instanceof TypeScriptCallSignature)) continue;
                hasCallSignature = true;
                if (TypeScriptResolveProcessor.checkParameterTypes((Ref<PsiElement>)Ref.create((Object)member), argumentTypes, genericArguments, inNewExpression) != null) continue;
                functionRef.set((Object)member);
                return null;
            }
            return hasCallSignature ? "javascript.argument.types.mismatch" : "javascript.term.does.not.evaluate.to.function";
        }
        if (type instanceof TypeScriptFunctionType) {
            return TypeScriptResolveProcessor.checkParameterTypes((Ref<PsiElement>)Ref.create((Object)type), argumentTypes, genericArguments, inNewExpression);
        }
        if (type instanceof TypeScriptSingleType || type instanceof TypeScriptTypeofType) {
            return JSTypeUtils.canBeCalledWithArguments(TypeScriptTypeParser.buildTypeFromTypeScript(type), argumentTypes, inNewExpression) ? null : "javascript.argument.types.mismatch";
        }
        return "javascript.argument.types.mismatch";
    }

    @Override
    public ResolveResult[] getResultsAsResolveResults() {
        ResolveResult[] results = super.getResultsAsResolveResults();
        if (this.myIncompleteCode) {
            return results;
        }
        if (TypeScriptResolveProcessor.isTypeMismatchResult(results)) {
            results[0] = new JSResolveResult(results[0].getElement());
            return results;
        }
        if (results.length > 0 && this.myCallParent != null) {
            return TypeScriptPsiUtil.chooseOverloads(results);
        }
        return results;
    }

    private static boolean isTypeMismatchResult(ResolveResult[] results) {
        return results.length == 1 && !results[0].isValidResult() && results[0] instanceof JSResolveResult && ((JSResolveResult)results[0]).getResolveProblemKey() == "javascript.argument.types.mismatch";
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "execute"));
        }
        if (this.myStrictTypeContext && !TypeScriptPsiUtil.isNamedTypeDefinition(element)) {
            return true;
        }
        if (this.myStrictTypeContainerContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) {
            return true;
        }
        if (!(this.myStrictTypeContext || !(this.place instanceof JSReferenceExpression) || !(element instanceof TypeScriptInterface) || this.place instanceof TypeScriptModule || this.place instanceof TypeScriptEntityName || this.place instanceof TypeScriptImportStatement || this.place.getParent() instanceof JSExportAssignment)) {
            return true;
        }
        return super.execute(element, state);
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "executeAcceptedElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "executeAcceptedElement"));
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration()) {
            return true;
        }
        PsiElement function = this.checkParameterTypes(element);
        if (function == null) {
            return false;
        }
        element = function;
        if (element instanceof TypeScriptIndexSignature && this.myName != null && ((TypeScriptIndexSignature)element).getMemberParameterType() instanceof JSStringType) {
            return ((ResolveResultSink)this.getResultSink()).addResult(element, state, this);
        }
        return super.executeAcceptedElement(element, state);
    }

    private static boolean isOverloadImplementation(PsiElement function) {
        return function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadImplementation();
    }

    @Override
    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getConstructor"));
        }
        PsiElement constructor = null;
        ResolveResult resolveResult = TypeScriptUtil.resolveConstructorMatchingArguments((JSClass)element, (JSExpression)this.place);
        if (!resolveResult.isValidResult()) {
            this.addPossibleCandidateResult(resolveResult.getElement(), "javascript.argument.types.mismatch");
            return null;
        }
        PsiElement constrOrClass = resolveResult.getElement();
        if (constrOrClass instanceof JSFunction && JSUtils.getMemberContainingClass(constrOrClass) == element) {
            constructor = constrOrClass;
        }
        return constructor == null ? element : constructor;
    }
}

