/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSEnterInNewFunctionHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JSEnterInNewFunctionHandler", "postProcessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSEnterInNewFunctionHandler", "postProcessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/javascript/editing/JSEnterInNewFunctionHandler", "postProcessEnter"));
        }
        Project project = file.getProject();
        boolean preferStrict = JSRootConfiguration.getInstance(project).getPreferStrict();
        if (!JSUtils.isJavaScriptFile(file) || !preferStrict) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement caretElement = file.findElementAt(caretOffset);
        if (caretElement == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretLineNumber = editor.getDocument().getLineNumber(caretOffset);
        PsiElement parent = caretElement.getParent();
        if (parent == null || !(parent instanceof JSBlockStatement) || caretLineNumber - 1 != editor.getDocument().getLineNumber(parent.getTextOffset()) || caretLineNumber + 1 != editor.getDocument().getLineNumber(parent.getTextOffset() + parent.getTextLength())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        JSBlockStatement blockStatement = (JSBlockStatement)parent;
        if (PsiTreeUtil.findChildOfType((PsiElement)blockStatement, JSStatement.class) != null || !(blockStatement.getParent() instanceof JSFunction)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        JSFunction function = (JSFunction)blockStatement.getParent();
        if (JSResolveUtil.isEcmaScript5((PsiElement)function)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)function, JSClass.class) != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        String quote = JSCodeStyleSettings.getQuote((PsiElement)file);
        String semicolon = JSCodeStyleSettings.getSemicolon(file);
        String useStrictStmt = quote + "use strict" + quote + semicolon;
        editor.getDocument().insertString(caretOffset, (CharSequence)useStrictStmt);
        editor.getCaretModel().moveToOffset(caretOffset + useStrictStmt.length());
        EnterAction.insertNewLineAtCaret((Editor)editor);
        return EnterHandlerDelegate.Result.Continue;
    }
}

