/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonObject;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSExternalAnnotator
extends ExternalAnnotator<JSFile, List<JSAnnotationError>> {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.flow.FlowJSExternalAnnotator");

    @Nullable
    public JSFile collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "collectInformation"));
        }
        if (file instanceof JSFile && file.getLanguage() == JavaScriptSupportLoader.FLOW_JS && FlowJSAnnotation.isFlowAnnotation(file)) {
            return (JSFile)file;
        }
        return null;
    }

    @Nullable
    public List<JSAnnotationError> doAnnotate(JSFile file) {
        if (file == null) {
            return null;
        }
        FlowJSServerService service = FlowJSServerService.getService(file.getProject());
        if (service == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        FlowJSConfig config = service.getConfig(virtualFile);
        if (config == null) {
            return null;
        }
        FlowJSServerService.saveSyncAllUnsavedFiles((PsiFile)file);
        String filePath = virtualFile.getParent().getPath();
        String fileName = virtualFile.getPath();
        String text = file.getText();
        List<JsonObject> requestAnswer = service.checkContentOfFile(config, text, fileName, filePath);
        JsonObject jsonAnswer = new JsonObject();
        if (requestAnswer.size() > 0) {
            jsonAnswer = requestAnswer.get(0);
        }
        return FlowJSServerService.parseFlowErrors(jsonAnswer, fileName);
    }

    public void apply(@NotNull PsiFile file, List<JSAnnotationError> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        ArrayList errorHighlightInfos = ContainerUtil.newArrayList();
        if (virtualFile == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            WolfTheProblemSolver.getInstance((Project)file.getProject()).clearProblems(virtualFile);
            return;
        }
        FlowJSExternalAnnotator.reportErrors(annotationResult, virtualFile, file, document, holder, null, errorHighlightInfos);
        JSLanguageServiceToolWindowManager jsLanguageServiceToolWindowManager = FlowJSToolWindowProvider.getToolWindow(file.getProject());
        if (jsLanguageServiceToolWindowManager != null) {
            ApplicationManager.getApplication().invokeLater(() -> jsLanguageServiceToolWindowManager.logCurrentErrors((List<JSAnnotationError>)ContainerUtil.immutableList((List)annotationResult), false));
        }
        List problems = errorHighlightInfos.stream().map(el -> new ProblemImpl(virtualFile, el, true)).collect(Collectors.toList());
        WolfTheProblemSolver.getInstance((Project)file.getProject()).reportProblems(virtualFile, problems);
    }

    public static void reportErrors(@NotNull List<JSAnnotationError> annotationResult, @NotNull VirtualFile virtualFile, @NotNull PsiFile file, @NotNull Document document, @Nullable AnnotationHolder annotationHolder, @Nullable ProblemsHolder problemsHolder, @Nullable ArrayList<HighlightInfo> errorHighlightInfos) {
        if (annotationResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResult", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "reportErrors"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "reportErrors"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "reportErrors"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSExternalAnnotator", "reportErrors"));
        }
        for (JSAnnotationError result : annotationResult) {
            if (StringUtil.isEmpty((String)result.getAbsoluteFilePath()) || !FileUtil.pathsEqual((String)result.getAbsoluteFilePath(), (String)virtualFile.getCanonicalPath())) continue;
            try {
                int lineStartOffset;
                int line = result.getLine();
                if (line < 0 || line >= document.getLineCount()) continue;
                int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
                int lineEndOffset = document.getLineEndOffset(line);
                if ((errorStartOffset += result.getColumn()) > lineEndOffset) continue;
                TextRange range = null;
                int lineTo = result instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result).getEndLine() : -1;
                PsiElement element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
                if (lineTo > 0) {
                    if (lineTo >= document.getLineCount()) continue;
                    int errorEndOffset = document.getLineStartOffset(lineTo);
                    int lineToEndOffset = document.getLineEndOffset(lineTo);
                    if ((errorEndOffset += ((JSAnnotationRangeError)result).getEndColumn()) > lineToEndOffset) continue;
                    range = TextRange.create((int)errorStartOffset, (int)(errorEndOffset + 1));
                }
                if (element == null && range == null) continue;
                String message = result.getDescription();
                Annotation annotation = null;
                if (annotationHolder != null) {
                    annotation = "error".equalsIgnoreCase(result.getCategory()) ? (element != null ? annotationHolder.createErrorAnnotation(element, message) : annotationHolder.createErrorAnnotation(range, message)) : (element != null ? annotationHolder.createWarningAnnotation(element, message) : annotationHolder.createWarningAnnotation(range, message));
                }
                if (problemsHolder != null && range != null) {
                    problemsHolder.registerProblem((PsiElement)file, range, message, new LocalQuickFix[0]);
                }
                if (errorHighlightInfos == null || annotation == null) continue;
                errorHighlightInfos.add(HighlightInfo.fromAnnotation(annotation));
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }
}

