/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import org.jetbrains.annotations.NotNull;

public class StandardJSCodeStyle
extends PredefinedCodeStyle {
    public StandardJSCodeStyle() {
        super("JavaScript Standard Style", (Language)JavascriptLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            throw new RuntimeException("Assertion failure. indent options were null");
        }
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        jsSettings.USE_DOUBLE_QUOTES = false;
        jsSettings.FORCE_QUOTE_STYlE = true;
        commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
        commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
        commonSettings.SPACE_BEFORE_DO_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_ELSE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_CATCH_KEYWORD = true;
        commonSettings.SPACE_BEFORE_FINALLY_KEYWORD = true;
        jsSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = true;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        jsSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR = true;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
        jsSettings.USE_SEMICOLON_AFTER_STATEMENT = false;
        jsSettings.FORCE_SEMICOLON_STYLE = true;
        jsSettings.SPACES_WITHIN_IMPORTS = true;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        commonSettings.SPACE_WITHIN_BRACKETS = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        jsSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES = false;
        commonSettings.SPACE_AFTER_QUEST = true;
        commonSettings.SPACE_BEFORE_QUEST = true;
        commonSettings.SPACE_BEFORE_COLON = true;
        commonSettings.SPACE_AFTER_COLON = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        commonSettings.SPACE_BEFORE_SEMICOLON = false;
        jsSettings.SPACE_BEFORE_PROPERTY_COLON = false;
        jsSettings.SPACE_AFTER_PROPERTY_COLON = true;
    }

    public static void install(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/formatter/StandardJSCodeStyle", "install"));
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        CodeStyleSettings newSettings = settingsManager.getCurrentSettings().clone();
        ((StandardJSCodeStyle)((Object)PredefinedCodeStyle.EP_NAME.findExtension(StandardJSCodeStyle.class))).apply(newSettings);
        settingsManager.USE_PER_PROJECT_SETTINGS = true;
        settingsManager.PER_PROJECT_SETTINGS = newSettings;
    }

    public static boolean isInstalled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/formatter/StandardJSCodeStyle", "isInstalled"));
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        CommonCodeStyleSettings commonSettings = codeStyleSettings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)codeStyleSettings.getCustomSettings(JSCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            throw new RuntimeException("Assertion failure. indent options were null");
        }
        return indentOptions.CONTINUATION_INDENT_SIZE == 2 && indentOptions.INDENT_SIZE == 2 && indentOptions.TAB_SIZE == 2 && !jsSettings.USE_DOUBLE_QUOTES && jsSettings.FORCE_QUOTE_STYlE && commonSettings.SPACE_BEFORE_METHOD_PARENTHESES && commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE && commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && commonSettings.KEEP_BLANK_LINES_IN_CODE == 1 && commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && !jsSettings.USE_SEMICOLON_AFTER_STATEMENT && jsSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH && jsSettings.FORCE_SEMICOLON_STYLE && jsSettings.SPACES_WITHIN_IMPORTS;
    }
}

