/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.execution.filters.Filter;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReactCreateAppProjectGenerator
extends NpmPackageProjectGenerator {
    @Nls
    @NotNull
    public String getName() {
        if ("React App" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "getName"));
        }
        return "React App";
    }

    public String getDescription() {
        return "<a href=\"https://github.com/facebookincubator/create-react-app\">Create React App</a> is a new officially supported way to create single-page React applications. It offers a modern build setup with no configuration.";
    }

    @Override
    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "filters"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "filters"));
        }
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "filters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String executable(String path) {
        String string = path + File.separator + "index.js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "executable"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "generatorArgs"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "generatorArgs"));
        }
        String[] stringArray = new String[1];
        String string = stringArray[0] = this.generateInTemp() ? baseDir.getName() : ".";
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "generatorArgs"));
        }
        return stringArray;
    }

    @Override
    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "customizeModule"));
        }
        Project project = ((ContentEntryImpl)entry).getRootModel().getProject();
        JSRootConfiguration.getInstance(project).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.JSX);
    }

    @Override
    @NotNull
    protected String packageName() {
        if ("create-react-app" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "packageName"));
        }
        return "create-react-app";
    }

    @Override
    @NotNull
    protected String presentablePackageName() {
        if ("create-react-&app:" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator", "presentablePackageName"));
        }
        return "create-react-&app:";
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    @Override
    protected boolean generateInTemp() {
        return PlatformUtils.isIntelliJ();
    }
}

