/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.webpack.WebpackConfigHighlightingInspection;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptAbstractProvider;
import com.intellij.lang.javascript.modules.PackageJsonDocumentDependencies;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackInJavaScriptJsonSchemaProvider
extends JsonSchemaInJavaScriptAbstractProvider {
    public static final Key<Boolean> FORCE_WEBPACK2_IN_TEST_KEY = Key.create((String)"JavaScript.Webpack.2.For.Tests");

    protected WebpackInJavaScriptJsonSchemaProvider() {
        super(WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile());
    }

    public static VirtualFile getWebpackSchemaFile() {
        return JsonSchemaProviderFactory.getResourceFile(WebpackInJavaScriptJsonSchemaProvider.class, (String)"/jsonSchemas/webpack-schema.json");
    }

    public boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailable"));
        }
        return WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(file) && WebpackInJavaScriptJsonSchemaProvider.isWebpack2(project);
    }

    static boolean isWebpack2(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && Boolean.TRUE.equals(project.getUserData(FORCE_WEBPACK2_IN_TEST_KEY))) {
            return true;
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return false;
        }
        VirtualFile packageJson = project.getBaseDir().findChild("package.json");
        if (packageJson != null) {
            ThreeState threeState = WebpackInJavaScriptJsonSchemaProvider.checkInPackageJsonVersion(project, packageJson);
            if (ThreeState.YES.equals((Object)threeState)) {
                return true;
            }
            if (ThreeState.NO.equals((Object)threeState)) {
                return false;
            }
            VirtualFile folder = packageJson.getParent();
            if (folder != null) {
                return Boolean.TRUE.equals(WebpackInJavaScriptJsonSchemaProvider.isWebpack2InNodeModules(folder));
            }
        } else {
            VirtualFile dir = project.getBaseDir();
            if (dir != null) {
                return Boolean.TRUE.equals(WebpackInJavaScriptJsonSchemaProvider.isWebpack2InNodeModules(dir));
            }
        }
        return false;
    }

    @Nullable
    private static Boolean isWebpack2InNodeModules(VirtualFile folder) {
        VirtualFile webpackPackageJson = VfsUtil.findRelativeFile((VirtualFile)folder, (String[])new String[]{"node_modules", "webpack", "package.json"});
        if (webpackPackageJson != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(webpackPackageJson);
            return data.getVersion() != null && data.getVersion().getMajor() >= 2;
        }
        return null;
    }

    private static ThreeState checkInPackageJsonVersion(Project project, VirtualFile packageJson) {
        PackageJsonDocumentDependencies.Dependencies dependencies = PackageJsonDocumentDependencies.getInstance().getForFile(project, packageJson);
        if (dependencies == null) {
            return ThreeState.NO;
        }
        String versionText = dependencies.getDependencies().get("webpack");
        if (versionText == null) {
            versionText = dependencies.getDevDependencies().get("webpack");
        }
        if (versionText != null) {
            return PackageJsonUtil.isVersionGreaterOrEqualMajor(StringUtil.unquoteString((String)versionText), 2);
        }
        return ThreeState.NO;
    }

    static boolean isAvailableForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailableForFile"));
        }
        return Registry.is((String)"JavaScript.WebPack.With.JsonSchema", (boolean)true) && StringUtil.startsWithIgnoreCase((String)file.getName(), (String)"webpack") && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    @NotNull
    public String getName() {
        if ("Webpack" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getName"));
        }
        return "Webpack";
    }

    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }

    public int getOrder() {
        return 1;
    }

    @Override
    protected boolean doAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "doAnnotation"));
        }
        return false;
    }

    @Override
    protected boolean doCompletionAndDocumentation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "doCompletionAndDocumentation"));
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String name = InspectionProfileEntry.getShortName((String)WebpackConfigHighlightingInspection.class.getSimpleName());
        InspectionToolWrapper tool = profile.getInspectionTool(name, element.getProject());
        return profile.isToolEnabled(HighlightDisplayKey.find((String)name), element) && tool != null && !tool.getTool().isSuppressedFor(element);
    }

    @Override
    protected boolean isInPoweredArea(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isInPoweredArea"));
        }
        return WebpackInJavaScriptJsonSchemaProvider.isInPoweredAreaStatic(element);
    }

    static boolean isInPoweredAreaStatic(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isInPoweredAreaStatic"));
        }
        PsiFile file = (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "lambda$isInPoweredAreaStatic$0"));
            }
            if (element.getContainingFile() == null || !element.isValid() || !element.getContainingFile().isValid()) {
                return null;
            }
            if (JSTokenTypes.STRING_LITERAL.equals(element.getNode().getElementType())) {
                return null;
            }
            return element.getContainingFile();
        });
        if (file == null) {
            return false;
        }
        List ranges = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(WebpackInJavaScriptJsonSchemaProvider.getModuleExportsParts(file), (Object[])new Object[]{file}));
        return ContainerUtil.or((Iterable)ranges, range -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "lambda$isInPoweredAreaStatic$2"));
            }
            return range.contains(element.getTextRange());
        });
    }

    private static List<TextRange> getModuleExportsParts(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getModuleExportsParts"));
        }
        List assignmentCandidates = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSAssignmentExpression.class).stream().filter(assignment -> (assignment.getParent() instanceof JSStatement || assignment.getParent() instanceof JSCommaExpression) && assignment.getDefinitionExpression() != null && WebpackInJavaScriptJsonSchemaProvider.isModuleExports(assignment.getDefinitionExpression().getExpression())).collect(Collectors.toList());
        List directParts = assignmentCandidates.stream().filter(assignment -> assignment.getDefinitionExpression().getInitializer() instanceof JSObjectLiteralExpression || assignment.getDefinitionExpression().getInitializer() instanceof JSArrayLiteralExpression).map(expression -> expression.getTextRange()).collect(Collectors.toList());
        List fromVariableReferences = assignmentCandidates.stream().map(assignment -> WebpackInJavaScriptJsonSchemaProvider.getObjectLiteralFromReference(assignment.getDefinitionExpression().getInitializer())).filter(literal -> literal != null).map(expression -> expression.getTextRange()).collect(Collectors.toList());
        directParts.addAll(fromVariableReferences);
        List lists = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSVariable.class).stream().filter(variable -> "webpackConfig".equalsIgnoreCase(variable.getName())).map(variable -> PsiTreeUtil.findChildrenOfAnyType((PsiElement)variable, (Class[])new Class[]{JSObjectLiteralExpression.class, JSArrayLiteralExpression.class})).filter(e -> e != null).collect(Collectors.toList());
        List fromVariable = ContainerUtil.concat(lists).stream().filter(e -> e != null).map(expression -> expression.getTextRange()).sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
        directParts.addAll(fromVariable);
        return directParts.stream().sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
    }

    private static JSExpression getObjectLiteralFromReference(JSExpression initializer) {
        JSExpression varInitializer;
        PsiElement resolve;
        if (initializer instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)initializer).resolve()) != null && resolve.isValid() && resolve instanceof JSVariable && (varInitializer = ((JSVariable)resolve).getInitializer()) instanceof JSObjectLiteralExpression) {
            return varInitializer;
        }
        return null;
    }

    private static boolean isModuleExports(@Nullable JSExpression expression) {
        return expression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "module", "exports") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "exports"));
    }
}

