/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationIntention
extends JavaScriptIntention {
    public JSSplitDeclarationIntention() {
        this.setText(JSBundle.message((String)"js.split.into.multiple.declarations", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        return varStatement != null && !(varStatement.getParent() instanceof TypeScriptEnum) && PsiTreeUtil.getChildOfType((PsiElement)varStatement, JSDestructuringContainer.class) == null && varStatement.getVariables().length > 1;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "invoke"));
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        assert (varStatement != null);
        String varModifier = varStatement.getVarKeyword().getText();
        String semicolon = JSCodeStyleSettings.getSemicolon(element.getContainingFile());
        JSVariable[] variables = varStatement.getVariables();
        JSVarStatement elem = varStatement;
        for (JSVariable variable : variables) {
            List<PsiComment> comments = JSSplitDeclarationIntention.collectLeadingComments(variable);
            JSDocComment docComment = JSSplitDeclarationIntention.getDocComment(variable, varStatement);
            if (docComment != null) {
                docComment.delete();
            }
            String docCommentText = docComment != null ? docComment.getText() + "\n" : "";
            for (PsiComment comment : comments) {
                elem = JSSplitDeclarationIntention.addElement(JSSplitDeclarationIntention.psiFromText((PsiElement)elem, comment.getText()), (PsiElement)elem);
            }
            PsiElement psi = JSSplitDeclarationIntention.psiFromText(element, docCommentText + varModifier + " " + variable.getText() + semicolon);
            elem = JSSplitDeclarationIntention.addElement(psi, (PsiElement)elem);
        }
        varStatement.delete();
    }

    @Nullable
    private static PsiElement psiFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "psiFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "psiFromText"));
        }
        return JSChangeUtil.createJSTreeFromText(context.getProject(), text, JSUtils.getDialect(context.getContainingFile())).getPsi();
    }

    @NotNull
    private static List<PsiComment> collectLeadingComments(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "collectLeadingComments"));
        }
        ArrayList results = ContainerUtil.newArrayList();
        for (PsiElement current = variable.getPrevSibling(); current != null && (current instanceof PsiComment || current instanceof PsiWhiteSpace); current = current.getPrevSibling()) {
            if (!(current instanceof PsiComment)) continue;
            results.add((PsiComment)current);
        }
        List list = ContainerUtil.reverse((List)results);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "collectLeadingComments"));
        }
        return list;
    }

    @NotNull
    private static PsiElement addElement(@Nullable PsiElement psi, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "addElement"));
        }
        if (psi == null) {
            PsiElement psiElement = context;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "addElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = context.getParent().addAfter(psi, context);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "addElement"));
        }
        return psiElement;
    }

    @Nullable
    public static JSDocComment getDocComment(@NotNull JSVariable variable, @NotNull JSVarStatement varStatement) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "getDocComment"));
        }
        if (varStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varStatement", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "getDocComment"));
        }
        JSVariable[] variables = varStatement.getVariables();
        JSVariable target = variables.length > 0 && variables[0] == variable ? varStatement : variable;
        return (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)target, JSDocComment.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.split.declarations", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention", "getFamilyName"));
        }
        return string;
    }
}

