/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonValueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonGenericValueAdapter
implements JsonValueAdapter {
    @NotNull
    private final JSExpression myValue;

    public JSJsonGenericValueAdapter(@NotNull JSExpression value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/json/JSJsonGenericValueAdapter", "<init>"));
        }
        this.myValue = value;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return this.myValue instanceof JSLiteralExpression && ((JSLiteralExpression)this.myValue).isQuotedLiteral();
    }

    public boolean isNumberLiteral() {
        return this.myValue instanceof JSLiteralExpression && ((JSLiteralExpression)this.myValue).isNumericLiteral() || this.myValue instanceof JSPrefixExpression && JSTokenTypes.MINUS.equals(((JSPrefixExpression)this.myValue).getOperationSign()) && ((JSPrefixExpression)this.myValue).getExpression() instanceof JSLiteralExpression && ((JSLiteralExpression)((JSPrefixExpression)this.myValue).getExpression()).isNumericLiteral();
    }

    public boolean isBooleanLiteral() {
        return this.myValue instanceof JSLiteralExpression && ((JSLiteralExpression)this.myValue).isBooleanLiteral();
    }

    public boolean isNull() {
        return this.myValue instanceof JSLiteralExpression && "null".equals(this.myValue.getText());
    }

    @NotNull
    public PsiElement getDelegate() {
        JSExpression jSExpression = this.myValue;
        if (jSExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/JSJsonGenericValueAdapter", "getDelegate"));
        }
        return jSExpression;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return false;
    }
}

