/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.SharedConfigurationPaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationPathsRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile fileAtElement = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileAtElement == null) {
            return null;
        }
        Project project = element.getProject();
        final SharedConfigurationPaths configurationPaths = SharedConfigurationPaths.getInstance(project);
        final SharedConfigurationPaths.PathHolderImpl holder = configurationPaths.remove(fileAtElement);
        if (holder != null) {
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/ConfigurationPathsRefactoringElementListenerProvider$1", "refactored"));
                    }
                    VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
                    if (newFile != null) {
                        configurationPaths.add(newFile, holder);
                    }
                }
            };
        }
        return null;
    }
}

