/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintView;
import com.intellij.lang.javascript.linter.eslint.service.ESLintLanguageService;
import com.intellij.lang.javascript.linter.eslint.service.StandardJSService;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EslintConfigurable
extends UntypedJSLinterConfigurable {
    public static final String ID = "settings.javascript.linters.eslint";

    public EslintConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintConfigurable", "<init>"));
        }
        this(project, false);
    }

    public EslintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintConfigurable", "<init>"));
        }
        super(project, fullModeDialog);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfigurable", "getId"));
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected JSLinterBaseView createView() {
        EslintView eslintView = new EslintView(this.getProject(), this.isFullModeDialog());
        if (eslintView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfigurable", "createView"));
        }
        return eslintView;
    }

    public void reset() {
        EslintView view = this.getEslintView();
        if (view == null) {
            return;
        }
        view.setExtendedState(this.loadUiState());
        this.resizeDialogToFitPreferredSize(view);
    }

    public void apply() {
        EslintView view = this.getEslintView();
        if (view == null) {
            return;
        }
        ExtendedLinterState state = view.getExtendedState();
        EslintView.UiState uiState = (EslintView.UiState)state.getState();
        boolean isStandardJS = ((EslintView.UiState)state.getState()).isStandardJS();
        EslintState eslintState = !isStandardJS ? uiState.getState() : EslintState.DEFAULT;
        StandardJSState standardJsState = new StandardJSState(uiState.getState().getInterpreterRef(), uiState.getState().getEslintPackagePath());
        this.setExtendedState(ExtendedLinterState.create(state.isEnabled() && isStandardJS, standardJsState), StandardJSConfiguration.class);
        this.setExtendedState(ExtendedLinterState.create(state.isEnabled() && !isStandardJS, eslintState), EslintConfiguration.class);
        ESLintLanguageService.getInstance(this.myProject).terminateStartedProcess(false);
        StandardJSService.getInstance(this.myProject).terminateStartedProcess(false);
    }

    @Override
    public boolean isModified() {
        EslintView view = this.getEslintView();
        if (view == null) {
            return false;
        }
        return !this.loadUiState().equals(view.getExtendedState());
    }

    private EslintView getEslintView() {
        return (EslintView)this.myView;
    }

    @NotNull
    private ExtendedLinterState<EslintView.UiState> loadUiState() {
        ExtendedLinterState eslintExtendedState = this.getExtendedState(EslintConfiguration.class);
        ExtendedLinterState standardJsExtendedState = this.getExtendedState(StandardJSConfiguration.class);
        EslintState eslintState = (EslintState)eslintExtendedState.getState();
        StandardJSState standardJSState = (StandardJSState)standardJsExtendedState.getState();
        boolean isStandardJS = standardJsExtendedState.isEnabled();
        EslintView.UiState uiState = isStandardJS ? new EslintView.UiState(new EslintState.Builder().setEslintPackagePath(standardJSState.getPackagePath()).setInterpreterRef(standardJSState.getInterpreterRef()).build(), true) : new EslintView.UiState(eslintState, false);
        ExtendedLinterState<EslintView.UiState> extendedLinterState = ExtendedLinterState.create(eslintExtendedState.isEnabled() || standardJsExtendedState.isEnabled(), uiState);
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfigurable", "loadUiState"));
        }
        return extendedLinterState;
    }
}

