/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.google.gson.JsonObject;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSUtil {
    public static final String PACKAGE_NAME = "standard";
    public static final String CONFIG_SECTION_NAME = "standard";
    public static final List<String> ESLINT_CONFIGURATION_NAMES = ContainerUtil.list((Object[])new String[]{"standard", "eslint-config-standard"});
    public static final int MIN_VERSION = 7;

    private StandardJSUtil() {
    }

    @Nullable
    public static NodePackage findEslintPackage(@NotNull NodePackage standardPackage) {
        if (standardPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardPackage", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil", "findEslintPackage"));
        }
        return StandardJSUtil.findDependentPackage(standardPackage, "eslint");
    }

    @Nullable
    private static NodePackage findDependentPackage(@NotNull NodePackage nodePackage, @NotNull String name) {
        if (nodePackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePackage", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil", "findDependentPackage"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil", "findDependentPackage"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(nodePackage.getSystemDependentPath()));
        if (file == null) {
            return null;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        VirtualFile nestedNodeModulesDir = file.findChild("node_modules");
        if (nestedNodeModulesDir != null) {
            NodeModuleSearchUtil.findModuleWithNameInDirectory(infos, nestedNodeModulesDir, ModuleType.CORE_MODULE, name);
        }
        NodeModuleSearchUtil.findModuleWithNameInDirectory(infos, file.getParent(), ModuleType.CORE_MODULE, name);
        CompletionModuleInfo item = (CompletionModuleInfo)ContainerUtil.getFirstItem((List)infos);
        return item != null && item.getAbsolutePath() != null ? new NodePackage(item.getAbsolutePath()) : null;
    }

    @Nullable
    public static ConfigData getPackageJsonConfigData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil", "getPackageJsonConfigData"));
        }
        return StandardJSUtil.getPackageJsonConfigData(project, project.getBaseDir().findChild("package.json"));
    }

    @Nullable
    public static ConfigData getPackageJsonConfigData(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil", "getPackageJsonConfigData"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (virtualFile == null) {
            return null;
        }
        return (ConfigData)ReadAction.compute(() -> {
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return (ConfigData)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
                try {
                    String text = VfsUtilCore.loadText((VirtualFile)virtualFile);
                    return CachedValueProvider.Result.create((Object)StandardJSUtil.parseSectionData(text), (Object[])new Object[]{virtualFile});
                }
                catch (Exception e) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{virtualFile});
                }
            });
        });
    }

    @Nullable
    private static ConfigData parseSectionData(@Nullable String text) throws Exception {
        JsonObject jsonObject = JsonUtil.tryParseJsonObject((String)text);
        if (jsonObject == null) {
            return null;
        }
        JsonObject sectionObject = JsonUtil.getChildAsObject((JsonObject)jsonObject, (String)"standard");
        if (sectionObject == null) {
            return null;
        }
        List plugins = ContainerUtil.notNullize((List)((List)ObjectUtils.coalesce((Object)JsonUtil.getChildAsSingleStringOrList((JsonObject)sectionObject, (String)"plugins"), (Object)JsonUtil.getChildAsSingleStringOrList((JsonObject)sectionObject, (String)"plugin"))));
        List globals = ContainerUtil.notNullize((List)((List)ObjectUtils.coalesce((Object)JsonUtil.getChildAsSingleStringOrList((JsonObject)sectionObject, (String)"globals"), (Object)JsonUtil.getChildAsSingleStringOrList((JsonObject)sectionObject, (String)"global"))));
        List ignored = ContainerUtil.notNullize((List)JsonUtil.getChildAsSingleStringOrList((JsonObject)sectionObject, (String)"ignore"));
        String parser = JsonUtil.getChildAsString((JsonObject)sectionObject, (String)"parser");
        JsonObject envObject = (JsonObject)ObjectUtils.coalesce((Object)JsonUtil.getChildAsObject((JsonObject)sectionObject, (String)"env"), (Object)JsonUtil.getChildAsObject((JsonObject)sectionObject, (String)"envs"));
        List env = envObject != null ? ContainerUtil.map((Collection)envObject.entrySet(), entry -> (String)entry.getKey()) : ContainerUtil.emptyList();
        return new ConfigData(plugins, ignored, globals, env, parser);
    }

    public static class ConfigData {
        public final List<String> plugins;
        public final List<String> ignored;
        public final List<String> globals;
        public final List<String> env;
        public final String parser;

        public ConfigData(@NotNull List<String> plugins, @NotNull List<String> ignored, @NotNull List<String> globals, @NotNull List<String> env, String parser) {
            if (plugins == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil$ConfigData", "<init>"));
            }
            if (ignored == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil$ConfigData", "<init>"));
            }
            if (globals == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globals", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil$ConfigData", "<init>"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil$ConfigData", "<init>"));
            }
            this.plugins = plugins;
            this.ignored = ignored;
            this.globals = globals;
            this.env = env;
            this.parser = parser;
        }

        public String toString() {
            return "ConfigData{plugins=" + this.plugins + ", ignored=" + this.ignored + ", globals=" + this.globals + ", env=" + this.env + ", parser='" + this.parser + '\'' + '}';
        }
    }
}

