/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfiguration;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.util.text.StringTokenizer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class GjsLintConfigFileChangeTracker {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static final Key<Boolean> PASS_REAL_PATH_KEY = Key.create((String)"PASS_REAL_PATH");

    public static void startTracking() {
        if (INSTALLED.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new GjsLintConfigFileVfsListener());
                EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
                multicaster.addDocumentListener((DocumentListener)new GjsLintConfigFileDocumentListener());
            }));
        }
    }

    private static void onChange(@NotNull VirtualFile file) {
        Project[] projects;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker", "onChange"));
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (project.isDisposed()) continue;
            GjsLintConfigFileChangeTracker.restartCodeAnalyzerIfNeeded(project, file);
        }
    }

    private static void restartCodeAnalyzerIfNeeded(@NotNull Project project, @NotNull VirtualFile changedFile) {
        String configFilePath;
        VirtualFile configVirtualFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker", "restartCodeAnalyzerIfNeeded"));
        }
        if (changedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker", "restartCodeAnalyzerIfNeeded"));
        }
        GjsLintConfiguration configuration = GjsLintConfiguration.getInstance(project);
        ExtendedLinterState extendedState = configuration.getExtendedState();
        if (extendedState.isEnabled() && changedFile.equals(configVirtualFile = JSLinterConfigFileUtil.findLocalFileByPath(configFilePath = ((GjsLintState)extendedState.getState()).getConfigFilePath()))) {
            PASS_REAL_PATH_KEY.set((UserDataHolder)configVirtualFile, null);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }

    public static boolean checkPassRealPath(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker", "checkPassRealPath"));
        }
        Boolean passRealPath = (Boolean)PASS_REAL_PATH_KEY.get((UserDataHolder)configFile);
        if (passRealPath == null) {
            passRealPath = GjsLintConfigFileChangeTracker.isPassRealPath(configFile);
            PASS_REAL_PATH_KEY.set((UserDataHolder)configFile, (Object)passRealPath);
        }
        return passRealPath;
    }

    private static boolean isPassRealPath(@NotNull VirtualFile configFile) {
        String text;
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker", "isPassRealPath"));
        }
        try {
            text = JSLinterConfigFileUtil.loadActualText(configFile);
        }
        catch (IOException e) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!"--passRealFilePath".equals(line = line.trim())) continue;
            return true;
        }
        return false;
    }

    private static class GjsLintConfigFileDocumentListener
    extends DocumentAdapter {
        private GjsLintConfigFileDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file != null) {
                GjsLintConfigFileChangeTracker.onChange(file);
            }
        }
    }

    private static class GjsLintConfigFileVfsListener
    extends VirtualFileAdapter {
        private GjsLintConfigFileVfsListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker$GjsLintConfigFileVfsListener", "fileCreated"));
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker$GjsLintConfigFileVfsListener", "fileDeleted"));
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker$GjsLintConfigFileVfsListener", "fileMoved"));
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker$GjsLintConfigFileVfsListener", "fileCopied"));
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
            GjsLintConfigFileChangeTracker.onChange(event.getOriginalFile());
        }
    }
}

