/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.ecmascript6.completion.ES6ImportExportSpecifierCompletionProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSBaseModulesSearcher;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSModulesSearcher
extends JSBaseModulesSearcher {
    private ModuleFixCreator myModuleFixCreator;
    private VirtualFile myModuleRoot;
    private boolean myOnlyCommonJs;

    public NodeJSModulesSearcher(@NotNull LocalInspectionToolSession session, @NotNull ModuleReferenceInfo info, @NotNull PsiElement node, @NotNull ResolveResult[] results, @NotNull Set<VirtualFile> files) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        super(session, info, node, results, files);
        this.myOnlyCommonJs = true;
    }

    public NodeJSModulesSearcher ignoreNodeLibraryAssociation() {
        this.myOnlyCommonJs = false;
        return this;
    }

    @Override
    public List<ModuleFixCreator.FixDescriptor> find() {
        this.myModuleRoot = NodeModuleUtil.getMainModuleRoot(this.mySession);
        if (this.myModuleRoot == null) {
            return Collections.emptyList();
        }
        this.myModuleFixCreator = new ModuleFixCreator(this.myPredefinedFiles, this.myModuleReferenceInfo);
        for (ResolveResult result : this.myResolveResults) {
            if (result.getElement() == null) continue;
            this.myModuleFixCreator.checkResolve(result.getElement());
        }
        if (this.myModuleFixCreator.isNoFixesShouldBeSuggested()) {
            return Collections.emptyList();
        }
        this.suggestHardcodedVariants();
        if (this.myModuleReferenceInfo.getTopLevelInModuleRef() != null) {
            if (!this.findVariantsForMethods(this.myModuleReferenceInfo)) {
                return this.myModuleFixCreator.getFixDescriptors();
            }
        } else {
            String referenceName = this.myModuleReferenceInfo.getReferenceName();
            if (referenceName != null) {
                VirtualFile byName;
                VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(this.myNode.getProject()).findCoreModuleFileByName(referenceName);
                if (coreModule != null) {
                    this.myModuleFixCreator.addFix(new ModuleFixCreator.FixDescriptor(ModuleFixCreator.ModuleType.nodejs, coreModule.getNameWithoutExtension(), coreModule, referenceName, null));
                    return this.myModuleFixCreator.getFixDescriptors();
                }
                this.findMatchingExports(referenceName);
                if (!this.myOnlyCommonJs && this.myModuleFixCreator.isEmpty()) {
                    this.findCandidatesFromImportedFiles(referenceName);
                }
                if (this.myModuleFixCreator.isEmpty() && (byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, referenceName)) != null && byName.getNameWithoutExtension().equals(referenceName)) {
                    this.myModuleFixCreator.addFix(new ModuleFixCreator.FixDescriptor(ModuleFixCreator.ModuleType.nodejs, referenceName, byName, referenceName, null));
                    return this.myModuleFixCreator.getFixDescriptors();
                }
            }
        }
        this.myModuleFixCreator.addShortModules();
        return this.myModuleFixCreator.getFixDescriptors();
    }

    private void suggestHardcodedVariants() {
        VirtualFile moduleFile;
        VirtualFile byName;
        String referenceName = this.myModuleReferenceInfo.getReferenceName();
        if ("React".equals(referenceName) && (byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, "react")) != null && byName.isDirectory() && (moduleFile = byName.findChild("react.js")) != null) {
            this.myModuleFixCreator.addFix(new ModuleFixCreator.FixDescriptor(ModuleFixCreator.ModuleType.nodejs, "react", moduleFile, "React", null));
        }
    }

    private void findCandidatesFromImportedFiles(String referenceName) {
        PsiFile file = this.myNode.getContainingFile();
        if (!(file instanceof JSFile)) {
            return;
        }
        Collection<ES6ImportDeclaration> imports = NodeJSModulesSearcher.findImportsInFile(file);
        HashSet<JSFile> filesFromImport = new HashSet<JSFile>();
        for (ES6ImportDeclaration anImport : imports) {
            PsiFile psiFile;
            ES6FromClause fromClause = anImport.getFromClause();
            if (fromClause == null) continue;
            Collection elements = fromClause.resolveReferencedElements();
            if ((elements = ContainerUtil.filter((Collection)elements, element -> element != null && element.isValid())).size() != 1 || !((psiFile = ((PsiElement)elements.iterator().next()).getContainingFile()) instanceof JSFile)) continue;
            filesFromImport.add((JSFile)psiFile);
        }
        for (JSFile jsFile : filesFromImport) {
            QualifiedItemProcessor<?> es6processor = ES6ImportExportSpecifierCompletionProvider.createCompletionProcessor((PsiFile)jsFile);
            ES6PsiUtil.processExportDeclarationInScope((JSElement)jsFile, es6processor, ResolveState.initial(), (PsiElement)jsFile);
            List<PsiElement> es6processorResults = es6processor.getResults();
            if (es6processorResults == null) continue;
            for (PsiElement result : es6processorResults) {
                if (!result.isValid() || !(result instanceof JSElementBase) || ((JSElementBase)result).getNamespace() != null || !referenceName.equals(((JSNamedElementBase)result).getName())) continue;
                this.processPossibleMatch(result, true);
            }
        }
    }

    private static Collection<ES6ImportDeclaration> findImportsInFile(PsiFile file) {
        return ES6ImportPsiUtil.getImportDeclarations((PsiElement)file);
    }

    private void findMatchingExports(String referenceName) {
        PsiFile file;
        for (ResolveResult result : this.myResolveResults) {
            PsiElement element;
            if (!result.isValidResult() && !"javascript.element.need.to.be.imported".equals(((JSResolveResult)result).getResolveProblemKey()) || (element = result.getElement()) == null) continue;
            this.processPossibleMatch(element, true);
        }
        if (this.myModuleReferenceInfo.processFromIndeces()) {
            this.searchWithStubIndex(this.myModuleReferenceInfo.getReferenceName(), this.myNode.getProject(), true);
        }
        if ((file = this.myNode.getContainingFile()) instanceof JSFile && DialectDetector.isES6((PsiElement)file)) {
            ArrayList<PsiFile> filesList = new ArrayList<PsiFile>();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myNode.getProject());
            filesList.addAll(Arrays.asList(FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".js"), (GlobalSearchScope)scope)));
            filesList.addAll(Arrays.asList(FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".jsx"), (GlobalSearchScope)scope)));
            filesList.addAll(Arrays.asList(FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".ts"), (GlobalSearchScope)scope)));
            for (PsiFile psiFile : filesList) {
                ModuleFixCreator.FixDescriptor descriptor;
                JSElement export;
                if (!(psiFile instanceof JSFile) || (export = ES6PsiUtil.findDefaultExport((JSElement)((JSFile)psiFile))) == null || (descriptor = this.addFixFromFile(psiFile, null, ModuleFixCreator.ModuleType.es6)) == null) continue;
                descriptor.setDefaultExport(true);
            }
        }
    }

    private void searchWithStubIndex(String referenceName, Project project, boolean withoutModuleWord) {
        ArrayList elementsToProcess = new ArrayList();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)referenceName, project, GlobalSearchScope.allScope((Project)project), JSElement.class, Processors.cancelableCollectProcessor(elementsToProcess));
        for (JSElement element : elementsToProcess) {
            this.processPossibleMatch((PsiElement)element, withoutModuleWord);
        }
    }

    private void processPossibleMatch(@NotNull PsiElement element, boolean withoutModuleWord) {
        String aliasText;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "processPossibleMatch"));
        }
        PsiFile file = element.getContainingFile();
        if (!(element.isValid() && file.isValid() && file instanceof JSFile)) {
            return;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return;
        }
        JSQualifiedName elementNamespace = ((JSQualifiedNamedElement)element).getNamespace();
        if (!this.myModuleReferenceInfo.isAcceptable(element)) {
            return;
        }
        JSFile jsFile = (JSFile)file;
        String string = aliasText = jsFile.getExportsInnerAlias() == null ? null : jsFile.getExportsInnerAlias().getTypeText();
        if (elementNamespace != null) {
            ModuleFixCreator.FixDescriptor descriptor;
            boolean isAlias = elementNamespace.getName().equals(aliasText);
            if ((NodeJSModulesSearcher.isExports(elementNamespace.getName()) || isAlias) && (descriptor = this.addFixFromFile((PsiFile)jsFile, withoutModuleWord ? ((JSQualifiedNamedElement)element).getName() : null, ModuleFixCreator.ModuleType.nodejs)) != null) {
                if (withoutModuleWord) {
                    descriptor.moduleElementIsMissing();
                }
                return;
            }
        }
        if (!DialectDetector.isES6((PsiElement)file)) {
            return;
        }
        this.resolveFromContextExports((JSQualifiedNamedElement)element, withoutModuleWord, jsFile);
    }

    private void resolveFromContextExports(@NotNull JSQualifiedNamedElement element, boolean withoutModuleWord, JSFile jsFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "resolveFromContextExports"));
        }
        String nameInExports = withoutModuleWord ? element.getName() : null;
        ContextInfo contextStatement = null;
        if (element.isExported() || (contextStatement = new ContextInfo(element)).isExported()) {
            ModuleFixCreator.FixDescriptor descriptor;
            if (!element.isExported() && contextStatement != null && contextStatement.getExportedName() != null) {
                nameInExports = contextStatement.getExportedName();
            }
            if ((descriptor = this.addFixFromFile((PsiFile)jsFile, nameInExports, ModuleFixCreator.ModuleType.es6)) != null) {
                descriptor.setDefaultExport(contextStatement != null && contextStatement.myIsDefaultExported);
            }
        }
    }

    private static boolean isExports(String text) {
        return "exports".equals(text) || "module.exports".equals(text);
    }

    private boolean findVariantsForMethods(@NotNull ModuleReferenceInfo moduleReferenceInfo) {
        ResolveResult[] results;
        if (moduleReferenceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReferenceInfo", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "findVariantsForMethods"));
        }
        for (ResolveResult resolveResult : results = this.myModuleReferenceInfo.resolveTopLevelInModuleRef()) {
            if (!resolveResult.isValidResult() || resolveResult.getElement() == null) continue;
            this.processPossibleMatch(resolveResult.getElement(), false);
        }
        if (moduleReferenceInfo.getTopLevelMember() != null) {
            this.searchWithStubIndex(this.myModuleReferenceInfo.getTopLevelMember(), this.myNode.getProject(), false);
        }
        return true;
    }

    private ModuleFixCreator.FixDescriptor addFixFromFile(PsiFile targetPsiFile, @Nullable String nameInExports, ModuleFixCreator.ModuleType moduleType) {
        VirtualFile targetFile;
        VirtualFile file = this.myNode.getContainingFile().getVirtualFile();
        if (file.equals(targetFile = targetPsiFile.getVirtualFile())) {
            return null;
        }
        ModuleFixCreator.FixDescriptor descriptor = NodeJSModulesSearcher.createFixDescriptionFromFile(this.myNode, this.myModuleReferenceInfo, this.myOnlyCommonJs, this.myModuleRoot, targetPsiFile, nameInExports, moduleType);
        if (descriptor != null) {
            this.myModuleFixCreator.addFix(descriptor);
        }
        return this.myModuleFixCreator.isNoFixesShouldBeSuggested() ? null : descriptor;
    }

    @Nullable
    public static ModuleFixCreator.FixDescriptor createFixDescriptionFromFile(PsiElement context, @NotNull ModuleReferenceInfo moduleReferenceInfo, boolean onlyCommonJs, @NotNull VirtualFile moduleRoot, @NotNull PsiFile targetPsiFile, @Nullable String nameInExports, @NotNull ModuleFixCreator.ModuleType moduleType) {
        if (moduleReferenceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReferenceInfo", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "createFixDescriptionFromFile"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "createFixDescriptionFromFile"));
        }
        if (targetPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPsiFile", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "createFixDescriptionFromFile"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "createFixDescriptionFromFile"));
        }
        VirtualFile file = context.getContainingFile().getVirtualFile();
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        boolean isCoreLibraryFile = NodeJsCoreLibraryManager.getInstance(context.getProject()).isCoreModuleLibraryFile(targetFile);
        ModuleFixCreator.FixDescriptor descriptor = null;
        if (isCoreLibraryFile) {
            descriptor = new ModuleFixCreator.FixDescriptor(moduleType, targetFile.getNameWithoutExtension(), targetFile, moduleReferenceInfo.getModuleName(), nameInExports);
        } else {
            String path;
            ForRequireModuleInfo required = NodeModuleUtil.canBeRequired(context.getProject(), moduleRoot, targetPsiFile, onlyCommonJs);
            if (required != null) {
                descriptor = NodeJSModulesSearcher.addFixForModule(context, moduleReferenceInfo, file, required, nameInExports, moduleType);
            } else if (ModuleFixCreator.ModuleType.es6.equals((Object)moduleType) && (path = NodeJSModulesSearcher.getImportPath(context, file, targetFile)) != null) {
                path = FileUtil.getNameWithoutExtension((String)path);
                descriptor = new ModuleFixCreator.FixDescriptor(moduleType, path, targetFile, moduleReferenceInfo.getModuleName(), nameInExports);
            }
        }
        return descriptor;
    }

    private static ModuleFixCreator.FixDescriptor addFixForModule(@NotNull PsiElement context, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull VirtualFile file, @NotNull ForRequireModuleInfo module, @Nullable String nameInExports, @NotNull ModuleFixCreator.ModuleType moduleType) {
        String exactPath;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "addFixForModule"));
        }
        if (moduleReferenceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReferenceInfo", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "addFixForModule"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "addFixForModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "addFixForModule"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "addFixForModule"));
        }
        ModuleType type = module.getType();
        ModuleFixCreator.FixDescriptor descriptor = null;
        if (ModuleType.NODE_MODULES_DIR.equals((Object)type)) {
            if (module.getModuleSourceRoot() != null) {
                String moduleName;
                String string = moduleName = module.getModuleSourceRoot().isDirectory() ? module.getModuleSourceRoot().getName() : module.getModuleSourceRoot().getNameWithoutExtension();
                if (module.isMainFile()) {
                    descriptor = new ModuleFixCreator.FixDescriptor(moduleType, moduleName, module.getModuleSourceRoot(), moduleReferenceInfo.getModuleName(), nameInExports);
                } else {
                    String redirectPath = NodeJSModulesSearcher.computeRedirectPath(context, module);
                    String relPath = FileUtil.getRelativePath((String)module.getModuleSourceRoot().getPath(), (String)module.getModuleFile().getPath(), (char)'/');
                    if (NodeJSModulesSearcher.relPathsSame(relPath, redirectPath, StringUtil.notNullize((String)module.getModuleFile().getExtension()))) {
                        descriptor = new ModuleFixCreator.FixDescriptor(moduleType, moduleName, module.getModuleFile(), moduleReferenceInfo.getModuleName(), nameInExports);
                    } else if (relPath != null && !relPath.startsWith("../")) {
                        relPath = relPath.startsWith("./") ? relPath.substring(1) : relPath;
                        relPath = moduleName + (relPath.startsWith("/") ? relPath : "/" + relPath);
                        descriptor = new ModuleFixCreator.FixDescriptor(moduleType, relPath, module.getModuleFile(), moduleReferenceInfo.getModuleName(), nameInExports);
                    }
                }
            }
        } else if (ModuleType.EXACT_PATH.equals((Object)type) && (exactPath = NodeJSModulesSearcher.getImportPath(context, file, module.getModuleFile())) != null) {
            descriptor = new ModuleFixCreator.FixDescriptor(moduleType, exactPath, module.getModuleFile(), moduleReferenceInfo.getModuleName(), nameInExports);
        }
        return descriptor;
    }

    @Nullable
    private static String computeRedirectPath(@NotNull PsiElement node, ForRequireModuleInfo module) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "computeRedirectPath"));
        }
        if (module.getMainFile() != null) {
            String redirectPath;
            VirtualFile main = module.getMainFile().getJsNextMain();
            if (main != null && (redirectPath = NodeJSModulesSearcher.getRedirectFileByRedirectPath(module, NodeModuleSearchUtil.getRedirectPathForModule(node.getProject(), main))) != null) {
                return redirectPath;
            }
            main = module.getMainFile().getMain();
            if (main != null) {
                return NodeJSModulesSearcher.getRedirectFileByRedirectPath(module, NodeModuleSearchUtil.getRedirectPathForModule(node.getProject(), main));
            }
        }
        return null;
    }

    @Nullable
    private static String getRedirectFileByRedirectPath(ForRequireModuleInfo module, @Nullable String redirectPath) {
        if (redirectPath == null) {
            return null;
        }
        redirectPath = redirectPath.startsWith("./") ? redirectPath.substring(2) : redirectPath;
        redirectPath = redirectPath.endsWith("/") ? redirectPath.substring(0, redirectPath.length() - 1) : redirectPath;
        VirtualFile virtualFile = VfsUtil.findRelativeFile((VirtualFile)module.getModuleSourceRoot(), (String[])new String[]{redirectPath});
        if (virtualFile != null && virtualFile.isDirectory()) {
            if (virtualFile.findChild("index.js") != null) {
                redirectPath = redirectPath + (redirectPath.endsWith("/") ? "" : "/") + "index.js";
            } else if (virtualFile.findChild("index.node") != null) {
                redirectPath = redirectPath + (redirectPath.endsWith("/") ? "" : "/") + "index.node";
            }
        }
        return redirectPath;
    }

    private static boolean relPathsSame(@Nullable String path1, @Nullable String path2, @NotNull String ext2) {
        if (ext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext2", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "relPathsSame"));
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        return (path1 = NodeJSModulesSearcher.normalizePath(path1)).equals(path2 = NodeJSModulesSearcher.normalizePath(path2)) || path1.equals(path2 + "." + ext2);
    }

    private static String normalizePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "normalizePath"));
        }
        return StringUtil.trimStart((String)StringUtil.trimStart((String)path, (String)"."), (String)"/");
    }

    private static String getImportPath(@NotNull PsiElement context, @NotNull VirtualFile placeFile, @NotNull VirtualFile moduleFile) {
        String path;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "getImportPath"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "getImportPath"));
        }
        if (moduleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFile", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "getImportPath"));
        }
        if (JSCodeStyleSettings.isUseAbsolutePath(context) && (path = ES6ImportPsiUtil.getPathRelativeToRoots(context, placeFile, moduleFile)) != null) {
            return path;
        }
        path = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)moduleFile, (char)'/');
        if (path == null) {
            return null;
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (path.startsWith(".")) {
            return path;
        }
        if (path.startsWith("/")) {
            return "." + path;
        }
        return "./" + path;
    }

    private static class ContextInfo {
        private boolean myIsExported;
        private boolean myIsDefaultExported;
        private PsiElement myContextElement;
        private String myExportedName;

        public ContextInfo(@NotNull JSQualifiedNamedElement element) {
            JSQualifiedNamedElement current;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$ContextInfo", "<init>"));
            }
            for (current = element; !(current instanceof JSStatement) && !(current instanceof JSFile) && current != null; current = current.getContext()) {
                if (this.myIsExported || !(current instanceof JSElementBase) || !(current instanceof JSNamedElement)) continue;
                JSElementBase elementBase = (JSElementBase)current;
                boolean directlyExported = elementBase.isExported();
                this.myIsDefaultExported = elementBase.isExportedWithDefault();
                if (!directlyExported && !this.myIsDefaultExported) continue;
                this.myExportedName = ((JSNamedElement)current).getName();
                this.myIsExported = true;
            }
            this.myContextElement = current;
            if (this.myContextElement instanceof ES6ExportDefaultAssignment) {
                this.myExportedName = ((ES6ExportDefaultAssignment)this.myContextElement).getInitializerReference();
                this.myIsExported = true;
                this.myIsDefaultExported = true;
            }
        }

        public boolean isExported() {
            return this.myIsExported;
        }

        public PsiElement getContextElement() {
            return this.myContextElement;
        }

        public String getExportedName() {
            return this.myExportedName;
        }
    }
}

