/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDocumentDependencies {
    private static final long STALE_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    public static final Key<CachedValue<Dependencies>> PACKAGE_JSON_DEPENDENCIES = Key.create((String)"Node.js.package.json.dependencies");
    private final Map<String, Long> myInProgressPackages = new HashMap();
    private final Object myLock = new Object();

    public static PackageJsonDocumentDependencies getInstance() {
        return (PackageJsonDocumentDependencies)ServiceManager.getService(PackageJsonDocumentDependencies.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInstall(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "startInstall"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInProgressPackages.put(name, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishInstall(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "finishInstall"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInProgressPackages.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeingInstalled(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "isBeingInstalled"));
        }
        Object object = this.myLock;
        synchronized (object) {
            Long ts = this.myInProgressPackages.get(name);
            if (ts == null) {
                return false;
            }
            if (System.currentTimeMillis() > ts + STALE_INTERVAL) {
                this.myInProgressPackages.remove(name);
                return false;
            }
            return true;
        }
    }

    @Nullable
    public Dependencies getForFile(Project project, @NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getForFile"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(packageJson);
        if (psiFile == null) {
            return null;
        }
        return (Dependencies)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)psiFile, PACKAGE_JSON_DEPENDENCIES, () -> {
            Dependencies dependencies = new Dependencies();
            PackageJsonDocumentDependencies.fillDependencies(psiFile, dependencies);
            return new CachedValueProvider.Result((Object)dependencies, new Object[]{psiFile});
        }, false);
    }

    private static void fillDependencies(PsiFile psiFile, Dependencies dependencies) {
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
        if (file == null || !file.isValid()) {
            return;
        }
        PsiElement[] children = file.getChildren();
        if (children.length == 0) {
            return;
        }
        JsonObject topObject = (JsonObject)ObjectUtils.tryCast((Object)children[0], JsonObject.class);
        if (topObject == null) {
            return;
        }
        PackageJsonDocumentDependencies.updateDependenciesProperty(topObject, dependencies.getDependencies(), PackageJsonField.dependencies.getName());
        PackageJsonDocumentDependencies.updateDependenciesProperty(topObject, dependencies.getDevDependencies(), PackageJsonField.devDependencies.getName());
        PackageJsonDocumentDependencies.updateDependenciesProperty(topObject, dependencies.getOptionalDependencies(), PackageJsonField.optionalDependencies.getName());
    }

    private static void updateDependenciesProperty(JsonObject topObject, Map<String, String> dependenciesMap, String name) {
        JsonProperty deps = topObject.findProperty(name);
        if (deps != null) {
            PackageJsonDocumentDependencies.updateDependenciesValues(deps, dependenciesMap);
        }
    }

    private static void updateDependenciesValues(JsonProperty deps, Map<String, String> dependencies) {
        JsonValue value = deps.getValue();
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
        if (object == null) {
            return;
        }
        List list = object.getPropertyList();
        for (JsonProperty property : list) {
            JsonValue propertyValue = property.getValue();
            JsonLiteral literal = (JsonLiteral)ObjectUtils.tryCast((Object)propertyValue, JsonLiteral.class);
            if (literal == null || !literal.isQuotedString()) continue;
            dependencies.put(property.getName().trim(), literal.getText());
        }
    }

    public static class Dependencies {
        private final Map<String, String> myDependencies = new HashMap();
        private final Map<String, String> myDevDependencies = new HashMap();
        private final Map<String, String> myOptionalDependencies = new HashMap();

        public Map<String, String> getDependencies() {
            return this.myDependencies;
        }

        public Map<String, String> getDevDependencies() {
            return this.myDevDependencies;
        }

        public Map<String, String> getOptionalDependencies() {
            return this.myOptionalDependencies;
        }
    }
}

