/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.Convertor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rainbow {
    public static final JBColor[] BLUE = new JBColor[]{new JBColor(new Color(4286945), new Color(4286945)), new JBColor(new Color(1869550), new Color(1869550)), new JBColor(new Color(4620980), new Color(4620980)), new JBColor(new Color(6535423), new Color(6535423)), new JBColor(new Color(49151), new Color(49151)), new JBColor(new Color(3383753), new Color(3383753)), new JBColor(new Color(62975), new Color(62975)), new JBColor(new Color(52685), new Color(52685)), new JBColor(new Color(239774), new Color(239774))};
    public static final JBColor[] LIGHT_BLUE = new JBColor[]{new JBColor(new Color(0xBFEFFF), new Color(0xBFEFFF)), new JBColor(new Color(0xBBFFFF), new Color(0xBBFFFF)), new JBColor(new Color(13693951), new Color(13693951)), new JBColor(new Color(14743800), new Color(14743800)), new JBColor(new Color(14155765), new Color(14155765))};
    public static final JBColor[] GRAY = new JBColor[]{new JBColor((Color)Gray._100, (Color)Gray._100), new JBColor((Color)Gray._90, (Color)Gray._90), new JBColor((Color)Gray._80, (Color)Gray._80), new JBColor((Color)Gray._70, (Color)Gray._70), new JBColor((Color)Gray._60, (Color)Gray._60), new JBColor((Color)Gray._50, (Color)Gray._50), new JBColor((Color)Gray._40, (Color)Gray._40)};
    public static final JBColor[] GRAY_FOR_DARCULA_BG = new JBColor[]{new JBColor(new Color(4150876), new Color(4150876)), new JBColor(new Color(3491917), new Color(3491917)), new JBColor(new Color(2899008), new Color(2899008))};
    public static final JBColor[] LIGHT_GRAY = new JBColor[]{new JBColor((Color)Gray._250, (Color)Gray._250), new JBColor((Color)Gray._240, (Color)Gray._240), new JBColor((Color)Gray._230, (Color)Gray._230), new JBColor((Color)Gray._220, (Color)Gray._220), new JBColor((Color)Gray._210, (Color)Gray._210), new JBColor((Color)Gray._200, (Color)Gray._200)};
    public static final JBColor[] RED = new JBColor[]{new JBColor(new Color(13470869), new Color(11826558)), new JBColor(new Color(15624871), new Color(15624871)), new JBColor(new Color(13459600), new Color(13459600)), new JBColor(new Color(13447800), new Color(13447800)), new JBColor(new Color(0xFF3030), new Color(0xFF3030)), new JBColor(new Color(0xFF6A6A), new Color(0xFF6A6A)), new JBColor(new Color(0xB22222), new Color(0xB22222)), new JBColor(new Color(0xCD0000), new Color(0xCD0000))};
    public static final JBColor[] LIGHT_RED = new JBColor[]{new JBColor(new Color(16767456), new Color(16767456)), new JBColor(new Color(16767473), new Color(16767473)), new JBColor(new Color(16772070), new Color(16772070)), new JBColor(new Color(16700884), new Color(16700884)), new JBColor(new Color(16756409), new Color(16756409)), new JBColor(new Color(16758213), new Color(16758213))};
    public static final JBColor[] VIOLET = new JBColor[]{new JBColor(new Color(16745466), new Color(0xEE77E9)), new JBColor(new Color(14706431), new Color(13591278)), new JBColor(new Color(12533503), new Color(12533503)), new JBColor(new Color(9514222), new Color(9514222))};
    public static final JBColor[] LIGHT_VIOLET = new JBColor[]{new JBColor(new Color(16769783), new Color(16769783)), new JBColor(new Color(15459839), new Color(15459839)), new JBColor(new Color(16766705), new Color(16766705)), new JBColor(new Color(13816302), new Color(13816302)), new JBColor(new Color(0xEECEE6), new Color(0xEECEE6))};
    public static final JBColor[] GREEN = new JBColor[]{new JBColor(new Color(64154), new Color(64154)), new JBColor(new Color(35653), new Color(35653)), new JBColor(new Color(51543), new Color(51543)), new JBColor(new Color(0x7CCD7C), new Color(0x7CCD7C)), new JBColor(new Color(8190976), new Color(8190976)), new JBColor(new Color(13303664), new Color(13303664)), new JBColor(new Color(11403055), new Color(11403055)), new JBColor(new Color(10145074), new Color(10145074)), new JBColor(new Color(0x8B8B00), new Color(0x8B8B00))};
    public static final JBColor[] LIGHT_GREEN = new JBColor[]{new JBColor(new Color(14614464), new Color(14614464)), new JBColor(new Color(13303664), new Color(13303664)), new JBColor(new Color(12253905), new Color(12253905)), new JBColor(new Color(10942909), new Color(10942909)), new JBColor(new Color(12438931), new Color(12438931)), new JBColor(new Color(0xCEE0CC), new Color(0xCEE0CC))};
    public static final JBColor[] YELLOW = new JBColor[]{new JBColor(new Color(0xFFFF00), new Color(0xFFFF00)), new JBColor(new Color(0xEEEE00), new Color(0xEEEE00)), new JBColor(new Color(16772235), new Color(16772235)), new JBColor(new Color(15654018), new Color(15654018)), new JBColor(new Color(16766720), new Color(16766720)), new JBColor(new Color(15649024), new Color(15649024))};
    public static final JBColor[] LIGHT_YELLOW = new JBColor[]{new JBColor(new Color(16515029), new Color(16515029)), new JBColor(new Color(0xFFF68F), new Color(0xFFF68F)), new JBColor(new Color(0xE6EEAE), new Color(0xE6EEAE)), new JBColor(new Color(16772035), new Color(16772035)), new JBColor(new Color(0xFFFFAA), new Color(0xFFFFAA))};
    public static final JBColor[] BROWN = new JBColor[]{new JBColor(new Color(13483632), new Color(13483632)), new JBColor(new Color(14929751), new Color(14929751)), new JBColor(new Color(13479168), new Color(13479168)), new JBColor(new Color(9139456), new Color(9139456)), new JBColor(new Color(13474589), new Color(13474589)), new JBColor(new Color(9136404), new Color(9136404)), new JBColor(new Color(12092939), new Color(12092939))};
    public static final JBColor[] LIGHT_BROWN = new JBColor[]{new JBColor(new Color(14929751), new Color(14929751)), new JBColor(new Color(14665880), new Color(14665880)), new JBColor(new Color(12103014), new Color(12103014))};
    public static final JBColor[] ORANGE = new JBColor[]{new JBColor(new Color(16753920), new Color(16753920)), new JBColor(new Color(15643682), new Color(15643682)), new JBColor(new Color(13473036), new Color(13473036)), new JBColor(new Color(16753920), new Color(16753920)), new JBColor(new Color(0xFF7F00), new Color(0xFF7F00)), new JBColor(new Color(16744228), new Color(16744228)), new JBColor(new Color(13460992), new Color(13460992))};
    public static final JBColor[] LIGHT_ORANGE = new JBColor[]{new JBColor(new Color(16762260), new Color(16762260)), new JBColor(new Color(16765600), new Color(16765600))};

    public static ColorGenerator createGenerator(@NotNull Condition<ColorGroup> selector, @Nullable Convertor<JBColor, JBColor> transformer, boolean light) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/lang/javascript/modules/diagramm/Rainbow", "createGenerator"));
        }
        List groups = Arrays.stream(ColorGroup.values()).filter(c -> {
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/lang/javascript/modules/diagramm/Rainbow", "lambda$createGenerator$0"));
            }
            return selector.value((Object)c);
        }).collect(Collectors.toList());
        final ArrayList<JBColor> colors = new ArrayList<JBColor>();
        for (ColorGroup group : groups) {
            boolean lightName = group.name().startsWith("light");
            if (light && !lightName || !light && lightName) continue;
            List<Object> list = Arrays.asList(group.getGroup());
            if (transformer != null) {
                list = list.stream().map(c -> (JBColor)transformer.convert(c)).collect(Collectors.toList());
            }
            colors.addAll(list);
        }
        Collections.shuffle(colors);
        return new ColorGenerator(){
            private int idx = -1;

            @Override
            public Color getColor() {
                ++this.idx;
                if (this.idx > colors.size() - 1) {
                    this.idx = 0;
                }
                return (Color)colors.get(this.idx);
            }
        };
    }

    public static interface ColorGenerator {
        public Color getColor();
    }

    public static enum ColorGroup {
        orange(ORANGE),
        red(RED),
        violet(VIOLET),
        green(GREEN),
        yellow(YELLOW),
        brown(BROWN),
        blue(BLUE),
        gray(GRAY),
        grayForDarculaBg(GRAY_FOR_DARCULA_BG),
        light_orange(LIGHT_ORANGE),
        light_red(LIGHT_RED),
        light_violet(LIGHT_VIOLET),
        light_green(LIGHT_GREEN),
        light_yellow(LIGHT_YELLOW),
        light_brown(LIGHT_BROWN),
        light_blue(LIGHT_BLUE),
        light_gray(LIGHT_GRAY);

        private final JBColor[] myGroup;

        private ColorGroup(JBColor[] group) {
            this.myGroup = group;
        }

        public JBColor[] getGroup() {
            return this.myGroup;
        }
    }
}

