/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing.modifiers;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;

public final class JSModifiersStructureLeaf
implements JSModifiersStructure {
    private final IElementType myTokenType;

    public JSModifiersStructureLeaf(IElementType tokenType) {
        this.myTokenType = tokenType;
    }

    @Override
    public boolean parseOptimistically(PsiBuilder builder) {
        if (this.isPossibleLookahead(builder)) {
            builder.advanceLexer();
            this.setContexts(builder);
            return true;
        }
        return false;
    }

    @Override
    public boolean parse(PsiBuilder builder, Predicate<PsiBuilder> isPossibleLookahead) {
        if (this.isPossibleLookahead(builder)) {
            PsiBuilder.Marker temp = builder.mark();
            builder.advanceLexer();
            if (isPossibleLookahead.test(builder)) {
                temp.drop();
                this.setContexts(builder);
                return true;
            }
            temp.rollbackTo();
        }
        return false;
    }

    private void setContexts(PsiBuilder builder) {
        if (this.myTokenType == JSTokenTypes.ASYNC_KEYWORD) {
            builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.FALSE);
        } else if (this.myTokenType == JSTokenTypes.MULT) {
            builder.putUserData(FunctionParser.IS_GENERATOR_FUNCTION_KEY, (Object)true);
        }
    }

    @Override
    public boolean isPossibleLookahead(PsiBuilder builder) {
        return builder.getTokenType() == this.myTokenType;
    }
}

