/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamepath;
import com.intellij.lang.javascript.psi.JSNamepathImpl;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamespaceImpl
extends UserDataHolderBase
implements JSNamespace {
    public static final JSNamespace UNDEFINED = new JSNamespaceImpl(null, JSContext.UNKNOWN, false);
    @Nullable
    protected final JSQualifiedName myName;
    @NotNull
    protected final JSContext myContext;
    protected final boolean myIsExplicitlyDeclared;
    private final boolean myIsLocal;

    public JSNamespaceImpl(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "<init>"));
        }
        this(qualifiedName, jsContext, isExplicitlyDeclared, false);
    }

    public JSNamespaceImpl(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isLocal) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "<init>"));
        }
        this.myName = qualifiedName;
        this.myContext = jsContext;
        this.myIsExplicitlyDeclared = isExplicitlyDeclared;
        this.myIsLocal = isLocal;
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return this.myName;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myContext;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "getJSContext"));
        }
        return jSContext;
    }

    public boolean isExplicitlyDeclared() {
        return this.myIsExplicitlyDeclared;
    }

    public boolean isLocal() {
        return this.myIsLocal;
    }

    public String toString() {
        JSQualifiedName name = this.getQualifiedName();
        return name != null ? name.getQualifiedName() : "<null>";
    }

    @NotNull
    public JSType toType(@Nullable PsiElement source) {
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, this.isExplicitlyDeclared());
        JSQualifiedName name = this.getQualifiedName();
        JSGlobalTypeImpl jSGlobalTypeImpl = name == null ? new JSGlobalTypeImpl(typeSource) : JSNamedType.createType(name.getQualifiedName(), typeSource, this.getJSContext());
        if (jSGlobalTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "toType"));
        }
        return jSGlobalTypeImpl;
    }

    @NotNull
    public static JSNamespace fromNamepath(@NotNull String namepath, boolean isExplicitlyDeclared) {
        if (namepath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namepath", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "fromNamepath"));
        }
        JSContext jsContext = JSContext.STATIC;
        if (namepath.endsWith(".prototype")) {
            namepath = namepath.substring(0, namepath.length() - "prototype".length() - 1);
            jsContext = JSContext.INSTANCE;
        } else if (namepath.endsWith("#")) {
            namepath = namepath.substring(0, namepath.length() - 1);
            jsContext = JSContext.INSTANCE;
        }
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(JSQualifiedNameImpl.fromNamepath(namepath), jsContext, isExplicitlyDeclared);
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "fromNamepath"));
        }
        return jSNamespaceImpl;
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isExplicitlyDeclared) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "buildProvidedNamespace"));
        }
        return JSNamespaceEvaluationResult.buildProvidedNamespace(element, isExplicitlyDeclared, null);
    }

    public boolean isEquivalentTo(@NotNull JSNamespace other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "isEquivalentTo"));
        }
        return ComparatorUtil.equalsNullable((Object)this.getQualifiedName(), (Object)other.getQualifiedName()) && this.getJSContext() == other.getJSContext() && this.isExplicitlyDeclared() == other.isExplicitlyDeclared();
    }

    @NotNull
    public static JSNamespace withContext(@NotNull JSNamespace ns, @NotNull JSContext context) {
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "withContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "withContext"));
        }
        if (context == ns.getJSContext()) {
            JSNamespace jSNamespace = ns;
            if (jSNamespace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "withContext"));
            }
            return jSNamespace;
        }
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(ns.getQualifiedName(), context, ns.isExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSNamespaceImpl", "withContext"));
        }
        return jSNamespaceImpl;
    }

    @Nullable
    public JSNamepath toNamepath() {
        ArrayList<String> components = new ArrayList<String>();
        for (JSQualifiedName name = this.myName; name != null; name = name.getParent()) {
            components.add(name.getName());
        }
        JSNamepathImpl result = null;
        for (int i = components.size() - 1; i >= 0; --i) {
            String component = (String)components.get(i);
            char contextChar = i == 0 && this.myContext == JSContext.INSTANCE ? (char)'#' : '\u0000';
            result = new JSNamepathImpl(component, result, contextChar);
        }
        return result;
    }
}

