/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ReferenceListStub;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSReferenceListImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceListImpl
extends JSReferenceListImpl<ES6ReferenceListStub>
implements ES6ReferenceList {
    public static final Key<ParameterizedCachedValue<Pair<ES6ReferenceList.Errors, Collection<JSType>>, PsiElement>> CACHE_KEY = Key.create((String)"ES6.Ref.list");
    public static final Condition<JSType> FUNCTION_TYPE_FILTER = type -> {
        JSFunctionTypeImpl jsType = ES6ReferenceListImpl.asFunctionType(type);
        return jsType != null;
    };
    public static final Pair<ES6ReferenceList.Errors, Collection<JSType>> NO_CONSTRUCTOR = Pair.create((Object)ES6ReferenceList.Errors.NO_CONSTRUCTOR, null);
    public static final Pair<ES6ReferenceList.Errors, Collection<JSType>> CIRCLE_ERROR = Pair.create((Object)ES6ReferenceList.Errors.CIRCLE, null);
    public static final ParameterizedCachedValueProvider<Pair<ES6ReferenceList.Errors, Collection<JSType>>, PsiElement> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Pair<ES6ReferenceList.Errors, Collection<JSType>>, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<Pair<ES6ReferenceList.Errors, Collection<JSType>>> compute(PsiElement expressionToResolve) {
            JSType type = JSTypeUtils.getValuableType(ES6ReferenceListImpl.getExpressionType(expressionToResolve));
            if (type instanceof JSNamedType && ES6ReferenceListImpl.isCycleDefs(type, expressionToResolve)) {
                return CachedValueProvider.Result.create(CIRCLE_ERROR, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            if (type != null) {
                Pair<ES6ReferenceList.Errors, Collection<JSType>> pair = ES6ReferenceListImpl.getConstructorSignatureType(type, expressionToResolve);
                return CachedValueProvider.Result.create(pair, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create(NO_CONSTRUCTOR, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };

    @Nullable
    public static JSFunctionTypeImpl asFunctionType(@Nullable JSType type) {
        if (type instanceof JSFunctionTypeImpl) {
            return (JSFunctionTypeImpl)type;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSType jsType = ((JSGenericTypeImpl)type).getType();
            return jsType instanceof JSFunctionTypeImpl ? (JSFunctionTypeImpl)jsType : null;
        }
        return null;
    }

    public static boolean isCycleDefs(@NotNull JSType type, @NotNull PsiElement expressionToResolve) {
        PsiElement parentClass;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "isCycleDefs"));
        }
        if (expressionToResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToResolve", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "isCycleDefs"));
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        PsiElement refList = PsiTreeUtil.getParentOfType((PsiElement)expressionToResolve, JSReferenceList.class);
        return refList != null && ES6ReferenceListImpl.matchCycleDefs(elements, parentClass = refList.getParent(), ContainerUtil.newHashSet());
    }

    public ES6ReferenceListImpl(ASTNode node) {
        super(node);
    }

    public ES6ReferenceListImpl(ES6ReferenceListStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public JSClass[] getReferencedClasses() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            if (JSClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getReferencedClasses"));
            }
            return JSClass.EMPTY_ARRAY;
        }
        JSImportHandler importHandler = this.getImportHandler();
        ArrayList<JSClass> supers = new ArrayList<JSClass>(members.length);
        for (JSReferenceListMember member : members) {
            String text = member.getReferenceText();
            if (text != null) {
                Collection<JSClass> classes = ES6ReferenceListImpl.resolveTextReferenceClasses(importHandler, text, (PsiElement)this);
                if (classes.isEmpty() && !DialectDetector.isTypeScript((PsiElement)this)) {
                    classes = this.resolveDirectlyToClasses(text);
                }
                if (classes.size() > 0) {
                    supers.addAll(classes);
                    continue;
                }
            }
            JSExpression element = member.getExpression();
            ES6ReferenceListImpl.resolveExpression((PsiElement)element, supers);
        }
        JSClass[] jSClassArray = supers.isEmpty() ? JSClass.EMPTY_ARRAY : (JSClass[])ContainerUtil.toArray(supers, (Object[])new JSClass[supers.size()]);
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getReferencedClasses"));
        }
        return jSClassArray;
    }

    private static void resolveExpression(PsiElement element, Collection<JSClass> supers) {
        Pair<ES6ReferenceList.Errors, Collection<JSType>> pair = ES6ReferenceListImpl.resolveExpression(element);
        if (pair.first != ES6ReferenceList.Errors.NO_ERROR) {
            return;
        }
        JSType functionType = (JSType)ContainerUtil.getFirstItem((Collection)((Collection)pair.second));
        JSType returnType = ES6ReferenceListImpl.getReturnType(functionType);
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(returnType);
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            supers.add((JSClass)psiElement);
        }
    }

    @Nullable
    public static JSType getExpressionType(PsiElement element) {
        JSType type = null;
        if (element instanceof JSExpression) {
            JSTypeEvaluationResult typeResult = JSTypeEvaluator.getExpressionType((JSExpression)element);
            if (typeResult != null) {
                type = typeResult.getType();
            }
        } else {
            type = JSTypeUtils.getTypeOfElement(element);
        }
        return type;
    }

    @NotNull
    public static Pair<ES6ReferenceList.Errors, Collection<JSType>> resolveExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveExpression"));
        }
        Ref ref = Ref.create();
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.CLASS_REFERENCE_LIST, el -> {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "lambda$resolveExpression$1"));
            }
            Pair result = (Pair)CachedValuesManager.getManager((Project)expression.getProject()).getParameterizedCachedValue((UserDataHolder)el, CACHE_KEY, CACHED_VALUE_PROVIDER, false, el);
            ref.set((Object)result);
        });
        if (ref.isNull()) {
            Pair<ES6ReferenceList.Errors, Collection<JSType>> pair = NO_CONSTRUCTOR;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveExpression"));
            }
            return pair;
        }
        Pair pair = (Pair)ref.get();
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveExpression"));
        }
        return pair;
    }

    @NotNull
    public static Pair<ES6ReferenceList.Errors, Collection<JSType>> getConstructorSignatureType(@Nullable JSType type, @NotNull PsiElement element) {
        Collection allFunctionTypes;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
        }
        if (type == null) {
            Pair<ES6ReferenceList.Errors, Collection<JSType>> pair = NO_CONSTRUCTOR;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
            }
            return pair;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = type.asRecordType();
        }
        if ((allFunctionTypes = (Collection)JSTypeUtils.getFunctionType(type, true).collect(Collectors.toList())).isEmpty()) {
            Pair pair = Pair.create((Object)ES6ReferenceList.Errors.NO_CONSTRUCTOR, (Object)ContainerUtil.createMaybeSingletonList((Object)type));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
            }
            return pair;
        }
        List types = ContainerUtil.filter((Collection)allFunctionTypes, FUNCTION_TYPE_FILTER);
        if (types.isEmpty()) {
            Pair pair = Pair.create((Object)ES6ReferenceList.Errors.NO_CONSTRUCTOR, (Object)ContainerUtil.createMaybeSingletonList((Object)type));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
            }
            return pair;
        }
        List matched = ContainerUtil.newSmartList();
        List<JSType> argumentsForExpression = ContainerUtil.emptyList();
        if (element instanceof JSExpression) {
            argumentsForExpression = TypeScriptGenericTypesEvaluator.getTypeArgumentsForExpression((JSExpression)element, null);
        }
        int argSize = argumentsForExpression.size();
        for (JSType constructorType : types) {
            JSType returnType;
            JSFunctionTypeImpl functionType = ES6ReferenceListImpl.asFunctionType(constructorType);
            if (functionType == null || (returnType = functionType.getReturnType()) == null || argSize != ES6ReferenceListImpl.getParameterListSize(constructorType)) continue;
            matched.add(constructorType);
        }
        if (matched.isEmpty()) {
            Pair pair = Pair.create((Object)ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS, (Object)ContainerUtil.createMaybeSingletonList((Object)type));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
            }
            return pair;
        }
        if (matched.size() > 1) {
            JSType item = ES6ReferenceListImpl.getReturnType((JSType)ContainerUtil.getFirstItem((Collection)matched));
            assert (item != null);
            boolean isFirst = true;
            for (JSType jsType : matched) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                if (item.isEquivalentTo(ES6ReferenceListImpl.getReturnType(jsType), null)) continue;
                Pair pair = Pair.create((Object)ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES, (Object)ContainerUtil.createMaybeSingletonList((Object)type));
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
                }
                return pair;
            }
        }
        Pair pair = Pair.create((Object)ES6ReferenceList.Errors.NO_ERROR, (Object)matched);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getConstructorSignatureType"));
        }
        return pair;
    }

    private static int getParameterListSize(JSType constructorType) {
        PsiElement sourceElement = constructorType.getSource().getSourceElement();
        if (sourceElement == null || !(sourceElement instanceof TypeScriptTypeParameterListOwner)) {
            return 0;
        }
        TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)sourceElement;
        TypeScriptTypeParameterList list = owner.getTypeParameterList();
        if (list == null) {
            return 0;
        }
        return list.getTypeParameters().length;
    }

    private static boolean matchCycleDefs(@NotNull Collection<? extends PsiElement> elements, @Nullable PsiElement toFind, @NotNull Collection<PsiElement> visited) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "matchCycleDefs"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "matchCycleDefs"));
        }
        if (!elements.isEmpty() && toFind != null) {
            for (PsiElement psiElement : elements) {
                Object[] classes;
                JSClass jsClass;
                if (!visited.add(psiElement)) {
                    return true;
                }
                if (psiElement.isEquivalentTo(toFind)) {
                    return true;
                }
                if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface() || (classes = jsClass.getSuperClasses()).length <= 0 || !ES6ReferenceListImpl.matchCycleDefs(ContainerUtil.newArrayList((Object[])classes), toFind, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<Pair<JSReferenceListMember, Collection<JSClass>>> getResolvedExpressions() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getResolvedExpressions"));
            }
            return list;
        }
        JSImportHandler handler = this.getImportHandler();
        List resolvedList = ContainerUtil.newSmartList();
        for (JSReferenceListMember member : members) {
            String text = member.getReferenceText();
            if (text != null) {
                Collection<JSClass> classes = ES6ReferenceListImpl.resolveTextReferenceClasses(handler, text, (PsiElement)this);
                if (classes.isEmpty() && !DialectDetector.isTypeScript((PsiElement)this)) {
                    classes = this.resolveDirectlyToClasses(text);
                }
                if (classes.size() > 0) {
                    resolvedList.add(Pair.create((Object)member, classes));
                    continue;
                }
            }
            List expectedClasses = ContainerUtil.newSmartList();
            ES6ReferenceListImpl.resolveExpression((PsiElement)member.getExpression(), expectedClasses);
            resolvedList.add(Pair.create((Object)member, (Object)expectedClasses));
        }
        List list = resolvedList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "getResolvedExpressions"));
        }
        return list;
    }

    @NotNull
    public static Collection<JSClass> resolveTextReferenceClasses(@NotNull JSImportHandler importHandler, @Nullable String text, @NotNull PsiElement thisElement) {
        if (importHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importHandler", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveTextReferenceClasses"));
        }
        if (thisElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisElement", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveTextReferenceClasses"));
        }
        if (text == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveTextReferenceClasses"));
            }
            return list;
        }
        JSTypeResolveResult result = importHandler.resolveName(text, thisElement);
        if (result.hasElements()) {
            List resultClasses = ContainerUtil.newSmartList();
            for (PsiElement psiElement : result.getElements()) {
                if (!(psiElement instanceof JSClass)) continue;
                resultClasses.add((JSClass)psiElement);
            }
            if (resultClasses.size() > 0) {
                List list = resultClasses;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveTextReferenceClasses"));
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl", "resolveTextReferenceClasses"));
        }
        return list;
    }

    @Nullable
    private static JSType getReturnType(@Nullable JSType type) {
        return type instanceof JSFunctionTypeImpl ? ((JSFunctionTypeImpl)type).getReturnType() : type;
    }
}

