/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ES6ChangeUtil {
    private ES6ChangeUtil() {
    }

    @NotNull
    public static JSDestructuringProperty createDestructuringProperty(@NotNull PsiElement context, @NotNull String propertyName, @NotNull String variableName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "createDestructuringProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "createDestructuringProperty"));
        }
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "createDestructuringProperty"));
        }
        String text = String.format("var {%s : %s}", propertyName, variableName);
        JSVarStatement varStatement = (JSVarStatement)((ASTNode)ObjectUtils.assertNotNull((Object)JSChangeUtil.createJSTreeFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context)))).getPsi(JSVarStatement.class);
        Ref propertyRef = new Ref();
        PsiTreeUtil.processElements((PsiElement)varStatement, element -> {
            JSDestructuringProperty destructuringProperty;
            JSDestructuringProperty jSDestructuringProperty = destructuringProperty = element instanceof JSDestructuringProperty ? (JSDestructuringProperty)element : null;
            if (element instanceof JSDestructuringProperty) {
                propertyRef.set((Object)destructuringProperty);
                return false;
            }
            return true;
        });
        JSDestructuringProperty jSDestructuringProperty = (JSDestructuringProperty)propertyRef.get();
        if (jSDestructuringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "createDestructuringProperty"));
        }
        return jSDestructuringProperty;
    }
}

