/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSLabeledStatementImpl
extends JSStatementImpl
implements JSLabeledStatement,
JSNamedElement {
    public JSLabeledStatementImpl(ASTNode node) {
        super(node);
    }

    public String getLabel() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier == null ? null : identifier.getText();
    }

    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
    }

    public PsiElement getLabelIdentifier() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getPsi() : null;
    }

    public JSStatement getStatement() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        return node != null ? (JSStatement)node.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSLabeledStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSLabeledStatement((JSLabeledStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getName() {
        return this.getLabel();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSLabeledStatementImpl", "setName"));
        }
        JSChangeUtil.doIdentifierReplacement((PsiElement)this, this.getLabelIdentifier(), name);
        return this;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }
}

