/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JSTypeInfo {
    private static JSContextLevel GLOBAL_CONTEXT_LEVEL = new JSContextLevel(new JSNamespaceImpl(null, JSContext.UNKNOWN, true), 0);
    private static int MAX_POSSIBLE_RELATIVE_LEVEL = 30;
    @NotNull
    public final List<JSContextLevel> myContextLevels = new ArrayList<JSContextLevel>();
    @Nullable
    public Collection<JSRecordType> myRecordTypes;
    private boolean myTypeWasProcessed;
    @NotNull
    private GlobalStatusHint myContextGlobalStatusHint = GlobalStatusHint.UNKNOWN;
    private boolean myForcedUnknownContext;

    protected void addType(String[] qualifiedTypeNameComponents) {
        this.addType(qualifiedTypeNameComponents, false, JSContext.UNKNOWN, true);
    }

    protected void addType(String[] qualifiedTypeNameComponents, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (qualifiedTypeNameComponents.length == 0) {
            return;
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromComponents(Arrays.asList(qualifiedTypeNameComponents));
        this.addType(new JSNamespaceImpl(qualifiedName, staticOrInstance, isExplicitlyDeclared), isTopClassInHierarchy);
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addType"));
        }
        this.addType(namespace, isTopClassInHierarchy, null);
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiFile jsModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addType"));
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        if (qualifiedName == null && !namespace.isExplicitlyDeclared()) {
            return;
        }
        if (qualifiedName == null && jsModule == null) {
            this.addGlobalType();
            return;
        }
        int relativeLevel = this.getRelativeLevel(isTopClassInHierarchy, qualifiedName);
        this.myContextLevels.add(new JSContextLevel(namespace, relativeLevel, jsModule));
    }

    private int getRelativeLevel(boolean isTopClassInHierarchy, JSQualifiedName qualifiedName) {
        if (qualifiedName.getParent() == null && "Object".equals(qualifiedName.getName())) {
            return MAX_POSSIBLE_RELATIVE_LEVEL;
        }
        if (qualifiedName.getParent() == null && "Function".equals(qualifiedName.getName())) {
            return MAX_POSSIBLE_RELATIVE_LEVEL - 1;
        }
        return isTopClassInHierarchy || this.myContextLevels.isEmpty() ? 0 : this.myContextLevels.get((int)(this.myContextLevels.size() - 1)).myRelativeLevel + 1;
    }

    public void addGlobalType() {
        this.myContextLevels.add(GLOBAL_CONTEXT_LEVEL);
    }

    public void addBaseObjectType() {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Object", null);
        JSNamespaceImpl namespace = new JSNamespaceImpl(name, JSContext.INSTANCE, false);
        this.myContextLevels.add(new JSContextLevel(namespace, MAX_POSSIBLE_RELATIVE_LEVEL));
    }

    public boolean isEmpty() {
        return this.myContextLevels.isEmpty();
    }

    public void setTypeWasProcessed() {
        this.myTypeWasProcessed = true;
    }

    public boolean typeWasProcessed() {
        return !this.myContextLevels.isEmpty() || this.myTypeWasProcessed;
    }

    public boolean hasExplicitNamespace() {
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (contextLevel.myRelativeLevel != 0 || !contextLevel.myNamespace.isExplicitlyDeclared()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchedNamespace(@Nullable JSQualifiedName namespace, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "hasMatchedNamespace"));
        }
        if (namespace == null) {
            return this.myContextLevels.size() == 0 || this.getGlobalStatusHint() == GlobalStatusHint.GLOBAL;
        }
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (!ComparatorUtil.equalsNullable((Object)namespace, (Object)contextLevel.myNamespace.getQualifiedName()) || !jsContext.isCompatibleWith(contextLevel.myNamespace.getJSContext())) continue;
            return true;
        }
        return false;
    }

    public void addRecordType(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordType", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addRecordType"));
        }
        if (this.myRecordTypes == null) {
            this.myRecordTypes = new SmartList();
        }
        this.myRecordTypes.add(recordType);
    }

    public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiFile jsModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addNamespace"));
        }
        this.addType(namespace, isTopClassInHierarchy, jsModule);
    }

    public final void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addNamespace"));
        }
        this.addNamespace(namespace, isTopClassInHierarchy, null);
    }

    public final void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared, @Nullable PsiFile jsModule) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addNamespace"));
        }
        JSQualifiedNameImpl qualifiedName = StringUtil.isQuotedString((String)type) ? JSQualifiedNameImpl.create(type, null) : JSQualifiedNameImpl.fromNamepath(type);
        JSNamespaceImpl namespace = new JSNamespaceImpl(qualifiedName, staticOrInstance, isExplicitlyDeclared);
        this.addNamespace(namespace, isTopClassInHierarchy, jsModule);
    }

    public final void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addNamespace"));
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, isExplicitlyDeclared, null);
    }

    public final void buildIndexListFromQNameAndCorrectQName(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "buildIndexListFromQNameAndCorrectQName"));
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, true);
    }

    public final void buildIndexListFromQNameAndCorrectQName(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "buildIndexListFromQNameAndCorrectQName"));
        }
        this.buildIndexListFromQNameAndCorrectQName(type, false, JSContext.UNKNOWN);
    }

    final void addAllParentScopes(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "addAllParentScopes"));
        }
        int lastIndexOfDot = qName.length();
        while (lastIndexOfDot > 0) {
            qName = qName.substring(0, lastIndexOfDot);
            this.buildIndexListFromQNameAndCorrectQName(qName);
            lastIndexOfDot = qName.lastIndexOf(".");
        }
        this.addGlobalType();
    }

    public boolean isGlobalStatusHint() {
        return this.getGlobalStatusHint() == GlobalStatusHint.GLOBAL;
    }

    public boolean isNonGlobalStatusHint() {
        return this.getGlobalStatusHint() == GlobalStatusHint.NONGLOBAL;
    }

    @NotNull
    private GlobalStatusHint getGlobalStatusHint() {
        if (this.myForcedUnknownContext) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
            if (globalStatusHint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "getGlobalStatusHint"));
            }
            return globalStatusHint;
        }
        boolean onlyGlobal = true;
        boolean onlyNonGlobal = true;
        boolean hasGlobal = false;
        boolean hasNonGlobal = false;
        boolean prevIsGlobal = false;
        for (JSContextLevel level : this.myContextLevels) {
            GlobalStatusHint contextLevelHint = JSTypeInfo.getContextLevelGlobalStatusHint(level);
            onlyGlobal &= contextLevelHint == GlobalStatusHint.GLOBAL || prevIsGlobal && level.myRelativeLevel == MAX_POSSIBLE_RELATIVE_LEVEL;
            onlyNonGlobal &= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            hasGlobal |= contextLevelHint == GlobalStatusHint.GLOBAL;
            hasNonGlobal |= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            prevIsGlobal = contextLevelHint == GlobalStatusHint.GLOBAL;
        }
        if (onlyGlobal && (hasGlobal || this.myContextGlobalStatusHint == GlobalStatusHint.GLOBAL)) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "getGlobalStatusHint"));
            }
            return globalStatusHint;
        }
        if (hasNonGlobal && onlyNonGlobal || this.myContextGlobalStatusHint == GlobalStatusHint.NONGLOBAL && !hasGlobal) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "getGlobalStatusHint"));
            }
            return globalStatusHint;
        }
        GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "getGlobalStatusHint"));
        }
        return globalStatusHint;
    }

    private static GlobalStatusHint getContextLevelGlobalStatusHint(@NotNull JSContextLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "getContextLevelGlobalStatusHint"));
        }
        if (level == GLOBAL_CONTEXT_LEVEL) {
            return GlobalStatusHint.GLOBAL;
        }
        JSQualifiedName qName = level.myNamespace.getQualifiedName();
        if (qName != null) {
            if (qName.getParent() == null && BaseJSSymbolProcessor.isNamedGlobalType(qName.getName(), level.myNamespace.getJSContext())) {
                return GlobalStatusHint.GLOBAL;
            }
            return GlobalStatusHint.NONGLOBAL;
        }
        return GlobalStatusHint.UNKNOWN;
    }

    public void setContextGlobalStatusHint(@NotNull GlobalStatusHint contextGlobalStatusHint) {
        if (contextGlobalStatusHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextGlobalStatusHint", "com/intellij/lang/javascript/psi/resolve/JSTypeInfo", "setContextGlobalStatusHint"));
        }
        this.myContextGlobalStatusHint = contextGlobalStatusHint;
        if (contextGlobalStatusHint == GlobalStatusHint.GLOBAL) {
            this.addGlobalType();
        }
    }

    public void setForcedUnknownContext() {
        this.myForcedUnknownContext = true;
    }

    static enum GlobalStatusHint {
        GLOBAL,
        NONGLOBAL,
        UNKNOWN;

    }
}

