/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeResolveResult {
    private final String myQualifiedName;
    private final Collection<? extends PsiElement> myElements;

    public JSTypeResolveResult(@NotNull String qualifiedName, @Nullable Collection<? extends PsiElement> elements) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/resolve/JSTypeResolveResult", "<init>"));
        }
        this.myQualifiedName = qualifiedName;
        this.myElements = elements;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeResolveResult", "getQualifiedName"));
        }
        return string;
    }

    public boolean hasElements() {
        return this.myElements != null;
    }

    @NotNull
    public Collection<? extends PsiElement> getElements() {
        Collection<Object> collection = this.myElements != null ? this.myElements : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeResolveResult", "getElements"));
        }
        return collection;
    }
}

