/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResolveProcessor
extends JSResolveProcessorBase {
    static final Key<String> ASKING_FOR_QUALIFIED_IMPORT = Key.create((String)"asking.for.import.of.qname");
    protected static final Key<Boolean> LOOKING_FOR_USE_NAMESPACES = Key.create((String)"looking.for.use.directive");
    public static final Key<ProcessingOptions> PROCESSING_OPTIONS = Key.create((String)"PROCESSING_OPTIONS");
    private final Set<JSClass> visitedClasses = new THashSet();
    private boolean toProcessHierarchy;
    private boolean toSkipClassDeclarationOnce;
    private boolean toProcessMembers = true;
    private boolean encounteredDynamicClasses;
    private boolean encounteredDynamicClassesSet;
    private boolean myTypeContext;
    private boolean localResolve;
    private boolean processingFromIndices;
    protected final PsiElement place;
    public static final Key<JSImportStatement> IMPORT_KEY = Key.create((String)"import.key");
    protected PsiElement nearestVarWeAreIn;
    private static final Key<Boolean> skipResolveKey = Key.create((String)"skip.package.local.check");
    private boolean myNeedsAllVariants;
    private boolean myForceImportsForPlace;
    public static final String AS3_NAMESPACE = "AS3";
    public static final PsiScopeProcessor.Event SCOPE_CHANGE = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event INHERITED_CLASSES_STARTED = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event INHERITED_CLASSES_FINISHED = new PsiScopeProcessor.Event(){};
    private ProcessingOptions myProcessingOptions = DEFAULT_RESOLVE;
    public static final ProcessingOptions DEFAULT_RESOLVE = new ProcessingOptions(){};
    protected final AccessibilityProcessingHandler accessibilityProcessingHandler;

    public ResolveProcessor(@Nullable String name) {
        this(name, null);
    }

    public ResolveProcessor(@Nullable String name, @Nullable PsiElement _place) {
        super(name);
        this.place = _place;
        this.accessibilityProcessingHandler = JSDialectSpecificHandlersFactory.forElement(_place).createAccessibilityProcessingHandler(this.place, this.isProcessingFromIndices());
        if (this.place != null) {
            ProcessingOptions processingOptionsOverride;
            PsiElement element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.place, (Class[])new Class[]{JSVariable.class, JSFunction.class});
            if (element instanceof JSVariable) {
                this.nearestVarWeAreIn = element;
            }
            if ((processingOptionsOverride = (ProcessingOptions)this.place.getContainingFile().getOriginalFile().getUserData(PROCESSING_OPTIONS)) != null) {
                this.setProcessingOptions(processingOptionsOverride);
            }
        }
    }

    public static boolean isSpecialCallResolveCaseEcmaScript(PsiElement place, PsiElement lastParent) {
        return lastParent instanceof JSCallExpression && place instanceof JSReferenceExpression && ((JSCallExpression)lastParent).getMethodExpression() == place && ((JSReferenceExpression)place).getQualifier() == null && lastParent.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    }

    static boolean completeConstructorName(PsiElement place) {
        PsiElement placeParent = place.getParent();
        return placeParent instanceof JSNewExpression && ((JSNewExpression)placeParent).getMethodExpression() == place;
    }

    public void prefixResolved() {
    }

    @Nullable
    public static String getName(PsiElement element) {
        if (element instanceof JSNamedElementBase) {
            return ((JSNamedElementBase)element).getName();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttributeValue("name");
        }
        if (element instanceof XmlToken) {
            return element.getText();
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        if (element instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)element).getReferenceName();
        }
        return null;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor", "getHint"));
        }
        return null;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor", "handleEvent"));
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER) {
            boolean toProcessParent = true;
            if (associated instanceof JSClass) {
                JSClass jsClass = (JSClass)associated;
                if (!this.toSkipClassDeclarationOnce) {
                    if (!this.encounteredDynamicClassesSet) {
                        JSAttributeList attributeList = jsClass.getAttributeList();
                        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC) || jsClass instanceof TypeScriptInterface) {
                            this.encounteredDynamicClasses = true;
                        }
                        this.encounteredDynamicClassesSet = true;
                    }
                } else {
                    toProcessParent = false;
                }
            }
            if (toProcessParent) {
                this.startingParent((PsiElement)associated);
            }
        } else if (event == INHERITED_CLASSES_STARTED) {
            this.accessibilityProcessingHandler.myProcessingInheritedClasses = true;
        } else if (event == INHERITED_CLASSES_FINISHED) {
            this.accessibilityProcessingHandler.myProcessingInheritedClasses = false;
        }
    }

    protected void startingParent(PsiElement associated) {
        this.accessibilityProcessingHandler.startingParent(associated);
    }

    public boolean isToProcessHierarchy() {
        return this.toProcessHierarchy;
    }

    public void setToProcessHierarchy(boolean toProcessHierarchy) {
        this.toProcessHierarchy = toProcessHierarchy;
    }

    public boolean isToSkipClassDeclarationOnce() {
        return this.toSkipClassDeclarationOnce;
    }

    public void setToSkipClassDeclarationsOnce(boolean toSkipClassDeclarationOnce) {
        this.toSkipClassDeclarationOnce = toSkipClassDeclarationOnce;
    }

    public void setTypeContext(boolean b) {
        this.myTypeContext = b;
    }

    public boolean isTypeContext() {
        return this.myTypeContext;
    }

    public boolean isToProcessMembers() {
        return this.toProcessMembers;
    }

    public void setToProcessMembers(boolean toProcessMembers) {
        this.toProcessMembers = toProcessMembers;
    }

    public boolean checkVisited(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor", "checkVisited"));
        }
        return !this.visitedClasses.add(clazz);
    }

    public boolean isLocalResolve() {
        return this.localResolve;
    }

    public boolean isProcessingFromIndices() {
        return this.processingFromIndices;
    }

    public void setSkipImplicitDeclarations(boolean processingFromIndices) {
        this.processingFromIndices = processingFromIndices;
    }

    public void setLocalResolve(boolean localResolve) {
        this.localResolve = localResolve;
    }

    public boolean specificallyAskingToResolveQualifiedNames() {
        return this.getUserData(ASKING_FOR_QUALIFIED_IMPORT) != null;
    }

    public String getQualifiedNameToImport() {
        return (String)this.getUserData(ASKING_FOR_QUALIFIED_IMPORT);
    }

    public boolean lookingForUseNamespaces() {
        return this.getUserData(LOOKING_FOR_USE_NAMESPACES) != null;
    }

    public boolean isEncounteredDynamicClasses() {
        return this.encounteredDynamicClasses;
    }

    public static void setSkipPackageLocalCheck(PsiElement el, boolean state) {
        el.putUserData(skipResolveKey, (Object)(state ? Boolean.TRUE : null));
    }

    public static boolean toSkipPackageLocalCheck(PsiElement el) {
        return el.getUserData(skipResolveKey) != null;
    }

    public void setNeedsAllVariants() {
        this.myNeedsAllVariants = true;
    }

    public boolean needsAllVariants() {
        return this.myNeedsAllVariants || this.specificallyAskingToResolveQualifiedNames();
    }

    public boolean isForceImportsForPlace() {
        return this.myForceImportsForPlace;
    }

    public void setForceImportsForPlace(boolean forceImportsForPlace) {
        this.myForceImportsForPlace = forceImportsForPlace;
    }

    public boolean needPackages() {
        return this.myProcessingOptions.needPackages();
    }

    @NotNull
    public ProcessingOptions getProcessingOptions() {
        ProcessingOptions processingOptions = this.myProcessingOptions;
        if (processingOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor", "getProcessingOptions"));
        }
        return processingOptions;
    }

    public void setProcessingOptions(@NotNull ProcessingOptions processingOptions) {
        if (processingOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingOptions", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor", "setProcessingOptions"));
        }
        this.myProcessingOptions = processingOptions;
    }

    @NotNull
    public AccessibilityProcessingHandler getAccessibilityProcessingHandler() {
        AccessibilityProcessingHandler accessibilityProcessingHandler = this.accessibilityProcessingHandler;
        if (accessibilityProcessingHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor", "getAccessibilityProcessingHandler"));
        }
        return accessibilityProcessingHandler;
    }

    public void configureClassScope(JSClass clazzOfContext) {
        this.accessibilityProcessingHandler.configureClassScope(clazzOfContext);
    }

    public void setAllowUnqualifiedStaticsFromInstance(boolean b) {
        this.accessibilityProcessingHandler.setAllowUnqualifiedStaticsFromInstance(b);
    }

    public void setTypeName(String qualifiedName) {
        this.accessibilityProcessingHandler.setTypeName(qualifiedName);
    }

    public boolean skipTopLevelItems() {
        assert (this.myName != null || this.place == null);
        return false;
    }

    public boolean needTopLevelClassName(String name) {
        assert (this.myName != null || this.place == null);
        return true;
    }

    public static abstract class ProcessingOptions {
        public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
            if (fun == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor$ProcessingOptions", "toProcessFunctionBodyDeclarations"));
            }
            return lastParent != null && lastParent.getParent() == fun;
        }

        public boolean toProcessFunctionArguments() {
            return true;
        }

        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null && packageStatement == lastParent.getParent();
        }

        public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return false;
        }

        public boolean needPackages() {
            return false;
        }

        @Nullable
        public Condition<PsiElement> getFilter() {
            return null;
        }
    }
}

