/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.util.Consumer;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyContextUtil {
    public static void applyTypeToContext(@NotNull JSType type, @Nullable JSEvaluationResultContext evaluateContext, @NotNull BiConsumer<JSType, JSEvaluationResultContext> consumer) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyTypeToContext"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "applyTypeToContext"));
        }
        if (evaluateContext == null) {
            consumer.accept(type, null);
            return;
        }
        JSApplyCallElement newElement = null;
        JSType baseType = null;
        if (type instanceof JSApplyCallType) {
            baseType = ((JSApplyCallType)type).getBaseType();
            newElement = new JSApplyCallElement(null);
        }
        if (newElement == null) {
            consumer.accept(type, evaluateContext);
            return;
        }
        JSType _baseType = baseType;
        JSEvaluateContext.processWithJSElementToApply(newElement, evaluateContext, (Consumer<JSEvaluationResultContext>)((Consumer)newContext -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil", "lambda$applyTypeToContext$0"));
            }
            consumer.accept(_baseType, (JSEvaluationResultContext)newContext);
        }));
    }
}

