/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeUtil {
    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub) {
        return StubTreeUtil.getNextSibling(stub, null);
    }

    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub, @Nullable TokenSet filter) {
        StubElement parentStub = stub.getParentStub();
        List children = parentStub.getChildrenStubs();
        if (StubTreeUtil.areTooManyChildren(children)) {
            StubElement lastChild = StubTreeUtil.getLastChild(children);
            return stub == lastChild ? null : StubTreeUtil.iterateNextSiblingsByPlainList(stub, filter, parentStub, lastChild);
        }
        boolean stubFound = false;
        for (StubElement child : children) {
            if (stubFound && StubTreeUtil.isAcceptable(filter, child)) {
                return child;
            }
            if (stub != child) continue;
            stubFound = true;
        }
        return null;
    }

    private static StubElement getLastChild(List<StubElement> children) {
        return children.get(children.size() - 1);
    }

    @Nullable
    private static StubElement iterateNextSiblingsByPlainList(@NotNull StubElement<?> stub, @Nullable TokenSet filter, @NotNull StubElement<?> parentStub, @NotNull StubElement lastChild) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "iterateNextSiblingsByPlainList"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "iterateNextSiblingsByPlainList"));
        }
        if (lastChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastChild", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "iterateNextSiblingsByPlainList"));
        }
        List<StubElement<?>> plainList = StubTreeUtil.getStubPlainList(parentStub);
        assert (stub == plainList.get(((ObjectStubBase)stub).id));
        while (stub != lastChild) {
            stub = StubTreeUtil.skipSubTree(stub, plainList);
            assert (stub.getParentStub() == parentStub);
            if (!StubTreeUtil.isAcceptable(filter, stub)) continue;
            return stub;
        }
        return null;
    }

    private static StubElement<?> skipSubTree(@NotNull StubElement<?> stub, List<StubElement<?>> plainList) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "skipSubTree"));
        }
        return plainList.get(((ObjectStubBase)StubTreeUtil.getLastLeaf(stub)).id + 1);
    }

    private static StubElement<?> getLastLeaf(StubElement<?> stub) {
        List children = stub.getChildrenStubs();
        return children.isEmpty() ? stub : StubTreeUtil.getLastLeaf(StubTreeUtil.getLastChild(children));
    }

    private static boolean areTooManyChildren(List<StubElement> children) {
        return children.size() > 10;
    }

    @NotNull
    private static List<StubElement<?>> getStubPlainList(StubElement<?> stub) {
        StubTree tree = (StubTree)ObjectStubTree.getStubTree((ObjectStubBase)((StubBase)StubTreeUtil.walkUp(null, stub)));
        assert (tree != null);
        List list = tree.getPlainList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "getStubPlainList"));
        }
        return list;
    }

    private static boolean isAcceptable(@Nullable TokenSet filter, @NotNull StubElement child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "isAcceptable"));
        }
        return filter == null || filter.contains((IElementType)child.getStubType());
    }

    @Nullable
    public static StubElement getPrevSibling(StubElement<?> stub) {
        StubElement parentStub = stub.getParentStub();
        List children = parentStub.getChildrenStubs();
        if (StubTreeUtil.areTooManyChildren(children)) {
            return children.get(0) == stub ? null : StubTreeUtil.findPrevSiblingByPlainList(stub, parentStub);
        }
        StubElement prevSibling = null;
        for (StubElement child : children) {
            if (stub == child) {
                return prevSibling;
            }
            prevSibling = child;
        }
        return null;
    }

    @NotNull
    private static StubElement findPrevSiblingByPlainList(StubElement<?> stub, StubElement<?> parentStub) {
        List<StubElement<?>> plainList = StubTreeUtil.getStubPlainList(parentStub);
        int index = ((ObjectStubBase)stub).id;
        assert (stub == plainList.get(index));
        assert (index > ((ObjectStubBase)parentStub).id + 1);
        StubElement stubElement = StubTreeUtil.walkUp(parentStub, plainList.get(index - 1));
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "findPrevSiblingByPlainList"));
        }
        return stubElement;
    }

    @NotNull
    private static StubElement walkUp(@Nullable StubElement<?> expectedParent, @NotNull StubElement start) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "walkUp"));
        }
        StubElement candidate = start;
        while (true) {
            StubElement candidateParent;
            if ((candidateParent = candidate.getParentStub()) == expectedParent) {
                StubElement stubElement = candidate;
                if (stubElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "walkUp"));
                }
                return stubElement;
            }
            candidate = candidateParent;
        }
    }

    @Nullable
    public static Language getJSLanguage(@NotNull StubElement<?> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "getJSLanguage"));
        }
        for (StubElement parent = stub; parent != null; parent = parent.getParentStub()) {
            stub = parent;
        }
        return stub instanceof JSFileStubImpl ? ((JSFileStubImpl)stub).getLanguage() : null;
    }

    @Nullable
    public static StubElement findChildStubByType(@NotNull StubElement<?> parent, @NotNull TokenSet types) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "findChildStubByType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "findChildStubByType"));
        }
        List children = parent.getChildrenStubs();
        for (StubElement child : children) {
            if (!types.contains((IElementType)child.getStubType())) continue;
            return child;
        }
        return null;
    }

    public static boolean isFromGlobalNamespace(StubElement startElement) {
        for (StubElement parentStub = startElement.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
            StubElement possibleFileElement;
            if (parentStub instanceof PsiFileStub) {
                if (parentStub instanceof JSFileStubImpl) {
                    JSFileStubImpl fileStub = (JSFileStubImpl)parentStub;
                    JSFileCachedData data = fileStub.getCachedData();
                    return data == null || data.getModuleStatus() != JSFile.ModuleStatus.ES6;
                }
                return true;
            }
            if (!(parentStub instanceof TypeScriptModuleStub) || !((possibleFileElement = parentStub.getParentStub()) instanceof JSFileStubImpl)) continue;
            String name = ((TypeScriptModuleStub)parentStub).getName();
            return name == null || !StringUtil.isQuotedString((String)name);
        }
        return true;
    }

    public static boolean checkParentStubShouldCreate(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "checkParentStubShouldCreate"));
        }
        ASTNode owner = node.getTreeParent();
        if (owner != null) {
            IElementType ownerType = owner.getElementType();
            if (ownerType instanceof IStubElementType) {
                return ((IStubElementType)ownerType).shouldCreateStub(owner);
            }
            if (ownerType instanceof JSFileElementType) {
                return true;
            }
        }
        return false;
    }
}

