/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeBaseImpl
extends UserDataHolderBase
implements JSType {
    @NotNull
    private JSTypeSource mySource;

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "<init>"));
        }
        this.mySource = source;
    }

    @NotNull
    public String getTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getTypeText"));
        }
        return string;
    }

    @NotNull
    public String getResolvedTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getResolvedTypeText"));
        }
        return string;
    }

    @NotNull
    public JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getSource"));
        }
        return jSTypeSource;
    }

    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == this || elementType == null || this.isEquivalentTo(elementType, processingContext, false) || JSTypeCastUtil.isAlwaysAssignableType(elementType)) {
            return true;
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "isDirectlyAssignableTypeImpl"));
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult;
    }

    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
    }

    public void setSourceIfEmpty(final @NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "setSourceIfEmpty"));
        }
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(){

            public void visitJSTypeBaseImpl(JSType type) {
                if (((JSTypeBaseImpl)type).mySource == JSTypeSource.EMPTY) {
                    ((JSTypeBaseImpl)type).mySource = source;
                }
                super.visitJSTypeBaseImpl(type);
            }
        };
        this.accept(visitor);
    }

    @Nullable
    public PsiFile getScope() {
        return this.mySource.getScope();
    }

    public boolean isEcma() {
        return this.mySource.isEcma();
    }

    public boolean isTypeScript() {
        return this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS;
    }

    public boolean isJavaScript() {
        return this.mySource.getLanguage() == JSTypeSource.SourceLanguage.JS;
    }

    public boolean isExplicitlyDeclared() {
        return this.mySource.isExplicitlyDeclared();
    }

    @NotNull
    protected JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage(language).getTypeHelper();
        if (jSTypeHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getTypeHelper"));
        }
        return jSTypeHelper;
    }

    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformation", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "transformTypeHierarchy"));
        }
        JSType transformedType = (JSType)transformation.fun((Object)this);
        if (this != transformedType) {
            JSType jSType = transformedType;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "transformTypeHierarchy"));
            }
            return jSType;
        }
        JSType jSType = this.copyTypeHierarchy(transformation);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "transformTypeHierarchy"));
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    @NotNull
    public JSType substitute() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "substitute"));
        }
        return jSTypeBaseImpl;
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type, processingContext, true);
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (this == type) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (this.isEquivalentToImpl(type, processingContext, allowResolve)) {
            return true;
        }
        return this.isEquivalentCommon(type, processingContext, allowResolve);
    }

    protected boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (rOperand instanceof JSGenericParameterImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        if (rOperand instanceof JSTypeofTypeImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public final JSType copyWithExplicitlyDeclared(boolean explicitly) {
        JSTypeSource source = this.getSource();
        if (source.isExplicitlyDeclared() == explicitly) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "copyWithExplicitlyDeclared"));
            }
            return jSTypeBaseImpl;
        }
        JSType jSType = this.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(source, explicitly));
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "copyWithExplicitlyDeclared"));
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    protected abstract boolean isEquivalentToImpl(@NotNull JSType var1, ProcessingContext var2, boolean var3);

    @NotNull
    public JSRecordType asRecordType() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        if (element != null) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)element.getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.asRecordTypeNoCache(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}));
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordType"));
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = this.asRecordTypeNoCache();
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordType"));
        }
        return jSRecordType;
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        Object id;
        JSRecordType result;
        JSType substitute = this.substitute();
        if (substitute != this && (result = (JSRecordType)RecursionManager.doPreventingRecursion((Object)(id = JSTypeCastUtil.getTypeIdForComparison(this)), (boolean)false, () -> substitute.asRecordType())) != null) {
            JSRecordType jSRecordType = result;
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordTypeNoCache"));
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(this);
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordTypeNoCache"));
        }
        return jSRecordType;
    }

    public static JSType replaceSourceRecursive(@Nullable JSType type, final @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSource", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "replaceSourceRecursive"));
        }
        if (type == null) {
            return null;
        }
        Function<JSType, JSType> function = new Function<JSType, JSType>(){

            public JSType fun(JSType currentType) {
                if (currentType instanceof JSTypeBaseImpl) {
                    if (currentType.getSource() == newSource) {
                        return currentType;
                    }
                    JSType elementResult = ((JSTypeBaseImpl)currentType).copyWithNewSource(newSource);
                    if (elementResult == currentType) {
                        return elementResult;
                    }
                    return elementResult.transformTypeHierarchy((Function)this);
                }
                assert (false);
                return currentType;
            }
        };
        return type.transformTypeHierarchy((Function)function);
    }
}

