/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassUtils {
    private JSClassUtils() {
    }

    public static boolean canHaveClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSClassUtils", "canHaveClasses"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        return holder != null && holder.hasFeature(JSLanguageFeature.CLASSES);
    }

    public static boolean isES6ClassImplementation(@Nullable PsiElement context) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        return JSClassUtils.isES6ClassImplementation(holder);
    }

    public static boolean isES6ClassImplementation(@Nullable DialectOptionHolder holder) {
        return holder != null && (holder.isECMA6 || holder.isTypeScript);
    }

    @NotNull
    public static String createClassFunctionName(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (JSClassUtils.isES6ClassImplementation(holder)) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
            }
            return string;
        }
        String string = "function " + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
        }
        return string;
    }

    @Nullable
    public static String getDefaultFieldQualifier(@NotNull PsiElement context, boolean withDot) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getDefaultFieldQualifier"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && (holder.isTypeScript || holder.isECMA6)) {
            return "this" + (withDot ? "." : "");
        }
        return null;
    }

    @Nullable
    public static String getAnyTypeString(@NotNull PsiElement context, boolean strict) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getAnyTypeString"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isECMA4) {
            return "*";
        }
        if (holder != null && holder.isTypeScript && strict) {
            return "any";
        }
        return null;
    }

    public static String createConstructorSignatureForClass(JSClass jsClass, boolean isPublic) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)jsClass);
        assert (holder != null);
        if (holder.isECMA4) {
            return (isPublic ? "public " : "") + "function " + jsClass.getName();
        }
        return "constructor";
    }

    @NotNull
    public static String getCast(@NotNull String type, @NotNull String expr, @NotNull DialectOptionHolder holder) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        if (holder.isTypeScript) {
            if (holder.isJSX) {
                String string = expr + " as " + type;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
                }
                return string;
            }
            String string = "<" + type + ">" + expr;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
            }
            return string;
        }
        String string = type + "(" + expr + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        return string;
    }

    public static boolean isAllowImplementation(@NotNull JSClass jsClass, @Nullable PsiElement context) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/util/JSClassUtils", "isAllowImplementation"));
        }
        return jsClass.isInterface() || context != null && DialectDetector.isTypeScript(context);
    }

    @Contract(value="null -> false")
    public static boolean isPossibleHierarchyMember(@Nullable PsiElement element) {
        return element instanceof JSFunction || element instanceof JSField && DialectDetector.isTypeScript(element);
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass<?> clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processClassesInHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processClassesInHierarchy"));
        }
        return JSClassUtils.processClassesInHierarchyImpl(clazz, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, null, ContainerUtil.newHashSet());
    }

    private static boolean processClassesInHierarchyImpl(@NotNull JSClass<?> clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor, @NotNull JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, @NotNull Set<JSClass> visited) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processClassesInHierarchyImpl"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processClassesInHierarchyImpl"));
        }
        if (typeSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processClassesInHierarchyImpl"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processClassesInHierarchyImpl"));
        }
        if (!visited.add(clazz)) {
            return true;
        }
        if (!processor.process(clazz, typeSubstitutor, fromImplements != null && fromImplements != false)) {
            return false;
        }
        if (clazz instanceof TypeScriptEnum) {
            return JSClassUtils.processEnumSuperClassesInHierarchy((TypeScriptEnum)clazz, includeInterfaces, processor, typeSubstitutor, fromImplements, visited);
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = clazz.getExtendsList();
        JSReferenceList implementsList = includeInterfaces ? clazz.getImplementsList() : null;
        int extendsListElementsLeft = 0;
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
            extendsListElementsLeft = superReferences.size();
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        for (Pair superReference : superReferences) {
            List<JSType> typeArguments = JSClassUtils.buildTypeArguments((JSReferenceListMember)superReference.first);
            boolean currentFromImplements = fromImplements == null ? extendsListElementsLeft-- <= 0 : fromImplements;
            Collection classes = (Collection)superReference.second;
            if (classes == null) continue;
            for (JSClass superClass : classes) {
                JSTypeSubstitutor combinedSubstitutor = JSClassUtils.combineSubstitutor(typeSubstitutor, typeArguments, superClass);
                if (includeInterfaces && superClass instanceof TypeScriptTypeAlias) {
                    ArrayList<JSClass> aliasResolves = new ArrayList<JSClass>();
                    TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)superClass, aliasResolves, null);
                    for (JSClass aliasResolve : aliasResolves) {
                        if (!JSClassUtils.canInclude(includeInterfaces, aliasResolve) || JSClassUtils.processClassesInHierarchyImpl(aliasResolve, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, currentFromImplements, visited)) continue;
                        return false;
                    }
                    continue;
                }
                if (!JSClassUtils.canInclude(includeInterfaces, superClass) || JSClassUtils.processClassesInHierarchyImpl(superClass, includeInterfaces, processor, combinedSubstitutor, currentFromImplements, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canInclude(boolean includeInterfaces, @NotNull JSClass superClass) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/lang/javascript/psi/util/JSClassUtils", "canInclude"));
        }
        return (includeInterfaces || !(superClass instanceof TypeScriptInterface)) && !"Object".equals(superClass.getName());
    }

    private static boolean processEnumSuperClassesInHierarchy(@NotNull TypeScriptEnum clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor, JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, Set<JSClass> visited) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processEnumSuperClassesInHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/util/JSClassUtils", "processEnumSuperClassesInHierarchy"));
        }
        for (JSClass aClass : clazz.getSupers()) {
            if (!JSClassUtils.canInclude(includeInterfaces, aClass) || JSClassUtils.processClassesInHierarchyImpl(aClass, includeInterfaces, processor, typeSubstitutor, fromImplements, visited)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<JSType> buildTypeArguments(@NotNull JSReferenceListMember referenceListMember) {
        if (referenceListMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceListMember", "com/intellij/lang/javascript/psi/util/JSClassUtils", "buildTypeArguments"));
        }
        JSTypeDeclaration[] typeArgumentDeclarations = referenceListMember.getTypeArguments();
        ArrayList typeArguments = ContainerUtil.newArrayListWithCapacity((int)typeArgumentDeclarations.length);
        for (JSTypeDeclaration typeArgumentDeclaration : typeArgumentDeclarations) {
            typeArguments.add(TypeScriptTypeParser.buildTypeFromTypeScript(typeArgumentDeclaration));
        }
        ArrayList arrayList = typeArguments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "buildTypeArguments"));
        }
        return arrayList;
    }

    private static JSTypeSubstitutor combineSubstitutor(@Nullable JSTypeSubstitutor typeSubstitutor, @NotNull List<JSType> typeArguments, @NotNull JSClass superClass) {
        JSTypeSubstitutor combinedSubstitutor;
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "com/intellij/lang/javascript/psi/util/JSClassUtils", "combineSubstitutor"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/lang/javascript/psi/util/JSClassUtils", "combineSubstitutor"));
        }
        TypeScriptTypeParameterList typeParameterList = superClass instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)superClass).getTypeParameterList() : null;
        JSTypeSubstitutor superClassSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterList, typeArguments);
        if (superClassSubstitutor != null) {
            combinedSubstitutor = new JSTypeSubstitutor();
            for (Map.Entry entry : superClassSubstitutor.entrySet()) {
                combinedSubstitutor.put(entry.getKey(), (Object)JSTypeUtils.applyGenericArguments((JSType)entry.getValue(), (Map<String, JSType>)typeSubstitutor));
            }
        } else {
            combinedSubstitutor = JSTypeSubstitutor.EMPTY;
        }
        return combinedSubstitutor;
    }
}

