/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.JSChangeVisibilityHandler;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeVisibilityUtil {
    public static void setVisibility(JSAttributeListOwner element, @Nullable JSAttributeList.AccessType visibility) {
        if (visibility == null) {
            return;
        }
        JSChangeVisibilityUtil.setVisibility(element, visibility, null);
    }

    public static void setVisibility(JSAttributeListOwner element, String visibility) {
        if (visibility != null) {
            JSChangeVisibilityUtil.setVisibility(element, JSAttributeList.AccessType.valueOf((String)visibility));
        }
    }

    public static void setVisibility(@NotNull JSAttributeListOwner startElement, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/refactoring/JSChangeVisibilityUtil", "setVisibility"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)startElement)) {
            return;
        }
        JSAttributeList list = startElement.getAttributeList();
        if (list != null && DialectDetector.isTypeScript((PsiElement)startElement)) {
            new JSChangeVisibilityHandler(list, visibility, false).apply();
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(list);
        if (visibility != null) {
            wrapper.overrideAccessType(visibility);
        } else if (namespace != null) {
            wrapper.overrideNamespace(namespace);
        }
        wrapper.applyTo(startElement);
    }

    public static void removeAccessModifier(JSAttributeListOwner element) {
        JSAttributeList attributeList = element.getAttributeList();
        if (attributeList == null) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeList);
        wrapper.removeAccessModifier();
        wrapper.applyTo(element);
    }

    public static String accessTypeToCodeString(@NotNull JSAttributeList.AccessType type, @Nullable PsiElement context) {
        DialectOptionHolder holder;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/refactoring/JSChangeVisibilityUtil", "accessTypeToCodeString"));
        }
        DialectOptionHolder dialectOptionHolder = holder = context == null ? null : DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isECMA6) {
            return "";
        }
        if (type == JSAttributeList.AccessType.PUBLIC && holder != null && holder.isTypeScript && !TypeScriptCodeStyleSettings.getTypeScriptSettings((Project)context.getProject()).USE_PUBLIC_MODIFIER) {
            return "";
        }
        return JSVisibilityUtil.accessTypeToKeyword(type, holder);
    }
}

