/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSLanguageServiceResultContainer {
    @NotNull
    private final List<String> myProcessedFiles;
    @NotNull
    private final List<String> myEmittedFiles;
    @NotNull
    private final List<JSAnnotationError> myAnnotationResults;

    public JSLanguageServiceResultContainer(@NotNull List<JSAnnotationError> annotationResults, @NotNull List<String> processedFiles, @NotNull List<String> emittedFiles) {
        if (annotationResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResults", "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer", "<init>"));
        }
        if (processedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedFiles", "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer", "<init>"));
        }
        if (emittedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emittedFiles", "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer", "<init>"));
        }
        this.myProcessedFiles = processedFiles;
        this.myAnnotationResults = annotationResults;
        this.myEmittedFiles = emittedFiles;
    }

    @NotNull
    public List<String> getEmittedFiles() {
        List<String> list = this.myEmittedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer", "getEmittedFiles"));
        }
        return list;
    }

    @NotNull
    public List<String> getProcessedFiles() {
        List<String> list = this.myProcessedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer", "getProcessedFiles"));
        }
        return list;
    }

    @NotNull
    public ImmutableList<JSAnnotationError> getAnnotationResults() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myAnnotationResults);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceResultContainer", "getAnnotationResults"));
        }
        return immutableList;
    }
}

