/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ide;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSLanguageServiceStartupActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity", "runActivity"));
        }
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        final List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        if (services.isEmpty()) {
            return;
        }
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity$1", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity$1", "fileOpened"));
                }
                services.forEach(service -> {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity$1", "lambda$fileOpened$0"));
                    }
                    if (service.isAcceptable(file)) {
                        service.openEditor(file);
                    }
                });
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity$1", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity$1", "fileClosed"));
                }
                if (source.getAllEditors(file).length == 0) {
                    services.forEach(service -> {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/ide/JSLanguageServiceStartupActivity$1", "lambda$fileClosed$1"));
                        }
                        if (service.isAcceptable(file)) {
                            service.closeLastEditor(file);
                        }
                    });
                }
            }
        });
    }
}

