/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MakeMethodStaticFix
implements IntentionAction,
LocalQuickFix {
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"make.method.static", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "applyFix"));
        }
        MakeMethodStaticFix.invoke(descriptor.getPsiElement());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "isAvailable"));
        }
        if (editor != null) {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            return element != null && element.isValid() && PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class}) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "invoke"));
        }
        if (editor != null) {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            MakeMethodStaticFix.invoke(element);
        }
    }

    private static void invoke(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "invoke"));
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class});
        Collection usages = Collections.synchronizedCollection(new HashSet());
        ReferencesSearch.search((PsiElement)function, (SearchScope)function.getUseScope()).forEach(psiReference -> {
            PsiElement element1 = psiReference.getElement();
            if (!(element1 instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression refExpr = (JSReferenceExpression)element1;
            if (refExpr.getQualifier() == null) {
                return true;
            }
            usages.add(refExpr);
            return true;
        });
        ArrayList<Object> elementsToWrite = new ArrayList<Object>();
        elementsToWrite.add(element);
        elementsToWrite.addAll(usages);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elementsToWrite)) {
            return;
        }
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)function);
        WriteAction.run(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix", "lambda$invoke$1"));
            }
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper(function.getAttributeList());
            wrapper.overrideModifier(JSAttributeList.ModifierType.STATIC, true);
            wrapper.overrideModifier(JSAttributeList.ModifierType.FINAL, false);
            wrapper.applyTo((JSAttributeListOwner)function);
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            HashSet filesToOptimizeImports = new HashSet();
            boolean actionScript = DialectDetector.isActionScript(element);
            for (JSReferenceExpression refExpr : usages) {
                JSClass currentClass = JSResolveUtil.getClassOfContext((PsiElement)refExpr);
                if (currentClass != null && currentClass.isEquivalentTo((PsiElement)clazz)) {
                    if (actionScript) {
                        JSRefactoringUtil.makeQualified(refExpr, null, false);
                        continue;
                    }
                    JSExpression qualifier = refExpr.getQualifier();
                    if (qualifier instanceof JSThisExpression) {
                        refExpr.deleteChildRange((PsiElement)qualifier, qualifier.getNextSibling());
                    }
                    JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)clazz, true);
                    continue;
                }
                if (actionScript) {
                    if (ImportUtils.needsImport(JSResolveUtil.getPackageNameFromPlace((PsiElement)refExpr), (JSQualifiedNamedElement)clazz)) {
                        FormatFixer formatter = ImportUtils.insertImportStatements((PsiElement)refExpr, Collections.singletonList(clazz.getQualifiedName()));
                        ContainerUtil.addIfNotNull(formatters, (Object)formatter);
                    }
                    filesToOptimizeImports.add(refExpr.getContainingFile());
                }
                JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)clazz, true);
            }
            for (PsiFile file : filesToOptimizeImports) {
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
            }
            FormatFixer.fixAll(formatters);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

