/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerConfigUtil {
    public static final String SOURCE_MAP = "--sourceMap";
    public static final String COMPILED_FILES = "compiledFiles";
    private static final String FILENAME = "filename";
    private static final String MESSAGE = "message";
    private static final String LINE = "line";
    private static final String COLUMN = "column";
    private static final String CATEGORY = "category";

    @NotNull
    public static String getConfigIdByConfig(@NotNull TypeScriptConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdByConfig"));
        }
        String string = TypeScriptCompilerConfigUtil.getConfigIdByConfig(config.getConfigFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdByConfig"));
        }
        return string;
    }

    public static String getConfigIdByConfig(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdByConfig"));
        }
        return JSHighlightingInfoBuilder.toPath(file);
    }

    @Nullable
    public static String getConfigIdForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdForFile"));
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForFile(project, file);
        return config == null ? null : TypeScriptCompilerConfigUtil.getConfigIdByConfig(config);
    }

    public static boolean isConfig(VirtualFile file, FileType type) {
        return "tsconfig.json".equals(file.getName());
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigForFile"));
        }
        return TypeScriptConfigUtil.getConfigForFile(project, file);
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "normalizeNameAndPath"));
        }
        return JSLanguageServiceUtil.normalizeNameAndPath(name);
    }

    public static void refreshFiles(@NotNull Project project, @NotNull Collection<String> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "refreshFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "refreshFiles"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$refreshFiles$1"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$refreshFiles$1"));
            }
            Collection result = (Collection)ReadAction.compute(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$null$0"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$null$0"));
                }
                if (project.isDisposed()) {
                    return ContainerUtil.emptyList();
                }
                HashSet dirtyFiles = ContainerUtil.newHashSet();
                for (String file : files) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)file);
                    VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                    if (path != null) {
                        dirtyFiles.add(path);
                        continue;
                    }
                    String parentDir = VfsUtil.getParentDir((String)systemIndependentName);
                    if (StringUtil.isEmpty((String)parentDir) || (path = LocalFileSystem.getInstance().findFileByPath(parentDir)) == null) continue;
                    dirtyFiles.add(path);
                }
                for (String file : dirtyFiles) {
                    Boolean data;
                    if (file.isDirectory() || Boolean.TRUE.equals(data = (Boolean)file.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER))) continue;
                    file.putUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER, (Object)Boolean.TRUE);
                }
                return dirtyFiles;
            });
            if (result.isEmpty()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)result));
        });
    }

    public static void processEmitFilesAfterCompiling(@NotNull Project project, @NotNull JsonObject objectWithFiles, @NotNull String fieldName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "processEmitFilesAfterCompiling"));
        }
        if (objectWithFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectWithFiles", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "processEmitFilesAfterCompiling"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "processEmitFilesAfterCompiling"));
        }
        JsonElement emitFiles = objectWithFiles.get(fieldName);
        if (emitFiles != null) {
            assert (emitFiles.isJsonArray());
            List<String> files = TypeScriptCompilerConfigUtil.jsonArrayToStringArray(emitFiles);
            if (files.isEmpty()) {
                return;
            }
            TypeScriptCompilerConfigUtil.refreshFiles(project, files);
        }
    }

    @NotNull
    public static List<String> jsonArrayToStringArray(JsonElement emitFiles) {
        List list = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Iterable)emitFiles.getAsJsonArray()), JsonElement::getAsString);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "jsonArrayToStringArray"));
        }
        return list;
    }

    @NotNull
    public static GlobalSearchScope getCompileScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getCompileScope"));
        }
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)project, (String)TypeScriptCompilerSettings.getSettings(project).getScopeName());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getCompileScope"));
        }
        return globalSearchScope;
    }
}

