/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixes;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptGetCodeFixesResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceFixSet {
    private static final int MAX_QUICK_FIXES = 5;
    private final JSLanguageServiceBase myLanguageService;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final TypeScriptLanguageServiceAnnotationResult myResult;
    @NotNull
    private final List<TypeScriptLanguageServiceFix> myFixes;
    private long myPsiModCount;

    @NotNull
    public List<TypeScriptLanguageServiceFix> getFixes() {
        List<TypeScriptLanguageServiceFix> list = this.myFixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "getFixes"));
        }
        return list;
    }

    public TypeScriptLanguageServiceFixSet(@NotNull JSLanguageServiceBase service, @NotNull VirtualFile file, @NotNull TypeScriptLanguageServiceAnnotationResult result) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        this.myLanguageService = service;
        this.myFile = file;
        this.myResult = result;
        ArrayList fixes = ContainerUtil.newArrayListWithCapacity((int)5);
        for (int i = 0; i < 5; ++i) {
            fixes.add(new TypeScriptLanguageServiceFix(this::refresh, i));
        }
        this.myFixes = fixes;
    }

    private void refresh() {
        long modCount = this.myFile.getModificationStamp();
        if (this.myPsiModCount == modCount) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myPsiModCount = modCount;
        if (!this.myLanguageService.checkCanUseService()) {
            return;
        }
        TypeScriptGetCodeFixesRequestArgs args = new TypeScriptGetCodeFixesRequestArgs();
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(this.myFile);
        args.startOffset = this.myResult.getColumn() + 1;
        args.startLine = this.myResult.getLine() + 1;
        args.endOffset = this.myResult.getEndColumn() + 1;
        args.endLine = this.myResult.getEndLine() + 1;
        args.errorCodes = new int[]{this.myResult.getErrorCode()};
        this.myFixes.forEach(el -> el.update(null));
        TypeScriptGetCodeFixes command = new TypeScriptGetCodeFixes(args);
        Future<TypeScriptGetCodeFixesResponse> future = this.myLanguageService.sendCommand(command, TypeScriptLanguageServiceFixSet.createGetCodeFixesProcessor());
        TypeScriptGetCodeFixesResponse response = JSLanguageServiceUtil.awaitFuture(future, 700L, 10L, null);
        if (response == null || response.body == null) {
            return;
        }
        int index = 0;
        for (TypeScriptCodeActionInfo info : response.body) {
            TypeScriptLanguageServiceFix fix = this.myFixes.get(index++);
            fix.update(new TypeScriptLanguageServiceFix.State(info));
            if (index >= 5) break;
        }
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse> createGetCodeFixesProcessor() {
        JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse> jSLanguageServiceCommandProcessor = new JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse>(){

            @Override
            @Nullable
            public TypeScriptGetCodeFixesResponse process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet$1", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet$1", "process"));
                }
                if (answer.isEmpty()) {
                    return null;
                }
                JsonObject element = answer.getElement();
                return (TypeScriptGetCodeFixesResponse)JSLanguageServiceQueue.GSON.fromJson((JsonElement)element, TypeScriptGetCodeFixesResponse.class);
            }
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "createGetCodeFixesProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }
}

