/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSmartCompletionContributor
extends JSSmartCompletionContributor {
    @Override
    @Nullable
    public List<?> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        List<Object> variants;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor", "getSmartCompletionVariants"));
        }
        if (location.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(location) && !(variants = this.addVariantsForUnqualifiedReference(location)).isEmpty()) {
            return variants;
        }
        return super.getSmartCompletionVariants(location);
    }

    @Override
    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<Object> variants) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor", "addVariantsForUnqualifiedExpectedType"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor", "addVariantsForUnqualifiedExpectedType"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor", "addVariantsForUnqualifiedExpectedType"));
        }
        if (TypeScriptSmartCompletionContributor.isEnumType(expectedType, location)) {
            Collection<? extends PsiElement> resolvedElements = TypeScriptTypeParser.resolveElementsByType(expectedType);
            for (PsiElement psiElement : resolvedElements) {
                JSField[] fields;
                if (!(psiElement instanceof TypeScriptEnum)) continue;
                for (JSField field : fields = ((TypeScriptEnum)psiElement).getFields()) {
                    variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, ((TypeScriptEnum)psiElement).getName() + "." + field.getName(), JSLookupPriority.SMART_PRIORITY, true, false));
                }
            }
        } else {
            List<LookupElement> result;
            JSType typedef;
            if (expectedType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)expectedType).getTypedef(null, null)) != null) {
                expectedType = typedef;
            }
            if ((result = TypeScriptSmartCompletionContributor.getStringLiteralVariantsForExpectedType((JSExpression)location, true, expectedType)) != null) {
                variants.addAll(result);
            }
        }
        super.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
    }

    private static boolean isEnumType(JSType expectedType, @NotNull JSReferenceExpression location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor", "isEnumType"));
        }
        return expectedType != null && expectedType instanceof JSTypeImpl && ((JSTypeImpl)expectedType).isEnum();
    }

    @Override
    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return true;
    }
}

