/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypescriptRemoveTypeDeclarationQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"typescript.remove.type.declaration", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypescriptRemoveTypeDeclarationQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/inspection/TypescriptRemoveTypeDeclarationQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/typescript/inspection/TypescriptRemoveTypeDeclarationQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        ASTNode variableNode = element.getParent().getNode();
        ASTNode colonNode = variableNode.findChildByType(JSTokenTypes.COLON);
        if (colonNode == null) {
            return;
        }
        variableNode.removeChild(colonNode);
        JSElementFactory.removeElement(element);
        JSElementFactory.reformat(element);
    }
}

