/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.typescript.inspection.TypescriptExplicitMemberTypeInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptSpecifyTypeExplicitlyQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix", "applyFix"));
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), (Class[])new Class[]{JSVariable.class, JSFunction.class});
        if (element == null || TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement(element) != null) {
            return;
        }
        JSType inferredType = TypescriptExplicitMemberTypeInspection.getInferredType(element);
        if (inferredType == null) {
            return;
        }
        String newTypeStr = JSVariablesWithInitializerPredicate.formatType(inferredType, element);
        PsiElement dummyVarStatement = JSChangeUtil.createStatementFromTextWithContext(element.getProject(), "var x: " + newTypeStr, element).getPsi();
        PsiElement newTypeDeclaration = ((JSTypeDeclarationOwner)PsiTreeUtil.getRequiredChildOfType((PsiElement)dummyVarStatement, JSTypeDeclarationOwner.class)).getTypeElement();
        PsiElement semicolon = JSChangeUtil.createColonPsiElement(project);
        PsiElement insertionAnchor = TypescriptSpecifyTypeExplicitlyQuickFix.getTypeDeclarationAnchor(element);
        if (newTypeDeclaration == null || insertionAnchor == null) {
            return;
        }
        element.addAfter(newTypeDeclaration, element.addAfter(semicolon, insertionAnchor));
        JSElementFactory.reformat(element);
    }

    @Nullable
    private static PsiElement getTypeDeclarationAnchor(@NotNull PsiElement element) {
        JSVariable variable;
        JSFunction function;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/inspection/TypescriptSpecifyTypeExplicitlyQuickFix", "getTypeDeclarationAnchor"));
        }
        JSFunction jSFunction = function = element instanceof JSFunction ? (JSFunction)element : null;
        if (function != null) {
            return ((JSBlockStatement)PsiTreeUtil.getRequiredChildOfType((PsiElement)function, JSBlockStatement.class)).getPrevSibling();
        }
        JSVariable jSVariable = variable = element instanceof JSVariable ? (JSVariable)element : null;
        if (variable != null) {
            return variable.getNameIdentifier();
        }
        return null;
    }
}

