/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.psi.TypeScriptAddImportExecutor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAutoImportUtil {
    private static final Logger LOGGER = Logger.getInstance(TypeScriptAutoImportUtil.class);
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT});
    public static final TokenSet ES6_IMPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION});
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    public static boolean isAvailableForImport(@NotNull JSElement elementToImport, JSReferencePlaceInfo placeInfo, @NotNull Project project) {
        boolean isClassType;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)elementToImport)) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)elementToImport)) {
            String name = elementToImport.getName();
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)elementToImport);
            LOGGER.error("Element " + name + " from " + (file == null ? elementToImport.getContainingFile() : file.getCanonicalPath()) + " must be a typescript element");
            return false;
        }
        boolean bl = isClassType = elementToImport instanceof JSClass || elementToImport instanceof TypeScriptModule;
        if (!TypeScriptAutoImportUtil.isContextAcceptable(elementToImport, placeInfo, isClassType)) {
            return false;
        }
        return TypeScriptAutoImportUtil.isExportedElement(project, (PsiElement)elementToImport, placeInfo);
    }

    public static boolean isExportedElement(Project project, PsiElement elementToImport, JSReferencePlaceInfo placeInfo) {
        TypeScriptModule tsModule;
        PsiElement parent = elementToImport.getContext();
        if (parent instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.container)) {
            return false;
        }
        if (parent instanceof TypeScriptModule && (tsModule = (TypeScriptModule)parent).isAugmentation() && !TypeScriptAutoImportUtil.isAugmentationAcceptable(tsModule)) {
            return false;
        }
        TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
        if (checker.check(placeInfo.place, elementToImport) != null) {
            return false;
        }
        return ES6ImportHandler.isExported(elementToImport) || elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault();
    }

    private static boolean isAugmentationAcceptable(@NotNull TypeScriptModule tsModule) {
        if (tsModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsModule", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAugmentationAcceptable"));
        }
        PsiElement parent = tsModule.getParent();
        if (!ES6PsiUtil.isExternalModule(parent)) {
            return false;
        }
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        return assignment instanceof TypeScriptExportAssignment;
    }

    public static boolean isContextAcceptable(@NotNull JSElement elementToImport, JSReferencePlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isContextAcceptable"));
        }
        if (elementToImport instanceof TypeScriptModule) {
            if (!((TypeScriptModule)elementToImport).isInternal()) {
                return false;
            }
            PsiElement module = TypeScriptPsiUtil.findExternalModule((PsiElement)elementToImport);
            if (module == null) {
                return false;
            }
        }
        if (placeInfo.isStrictTypeContext && !isClassType) {
            return false;
        }
        return TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType);
    }

    private static boolean isElementCanBeUsedInContext(@NotNull JSElement elementToImport, @NotNull JSReferencePlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        PsiElement parentContext = placeInfo.parent;
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptInterface) || !isCallContext;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(element)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$1", "contains"));
                }
                if (!super.contains(file) || !TypeScriptAutoImportUtil.checkDefinitionForNodeModules(file, project)) {
                    return false;
                }
                return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType());
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        return delegatingGlobalSearchScope;
    }

    public static boolean checkDefinitionForNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (TypeScriptUtil.isUnderNodeModules(file, project)) {
            return TypeScriptUtil.isDefinitionFile(file);
        }
        return true;
    }

    public static void addImportStatement(String name, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        TypeScriptAutoImportUtil.addImportStatement(null, name, elementToImport, place);
    }

    public static void addImportStatement(@Nullable Editor editor, String name, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        new TypeScriptAddImportExecutor(name, editor, place).execute(elementToImport);
    }

    public static void showError(Project project, @Nullable Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot find module for import", (String)TypeScriptAutoImportUtil.getActionName(), null);
    }

    static boolean isSelfExportedAugmentationModule(@NotNull TypeScriptModule container) {
        String reference;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isSelfExportedAugmentationModule"));
        }
        PsiElement parent = container.getParent();
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        if (assignment != null && (reference = assignment.getInitializerReference()) != null) {
            JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
            return result.getElements().contains(container);
        }
        return false;
    }

    @Nullable
    public static PsiElement getScopeToAddImport(@NotNull PsiElement place, boolean fromExternalModule) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getScopeToAddImport"));
        }
        if (!(place.getContainingFile() instanceof JSFile)) {
            return PsiTreeUtil.getParentOfType((PsiElement)place, JSEmbeddedContent.class);
        }
        return fromExternalModule ? PsiTreeUtil.getParentOfType((PsiElement)place, JSFile.class) : PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{JSFile.class, TypeScriptModule.class});
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6Import(@NotNull PsiElement placeModule, @Nullable PsiElement module, @NotNull String moduleName, boolean anyImport) {
        if (placeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeModule", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingES6Import"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingES6Import"));
        }
        PsiElement[] declarations = JSResolveUtil.getStubbedChildren(placeModule, ES6_IMPORT_DECLARATION);
        if (declarations.length == 0) {
            return null;
        }
        ES6ImportDeclaration result = TypeScriptAutoImportUtil.findExistingES6ImportByFromText(declarations, moduleName, anyImport);
        if (result != null) {
            return result;
        }
        return TypeScriptAutoImportUtil.findExistingES6ImportByFromModules(declarations, module, anyImport);
    }

    public static TypeScriptImportStatement createTypeScriptImport(@NotNull PsiElement place, @NotNull ES6ImportPsiUtil.ImportedElementCreateInfo info, @NotNull String moduleName) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createTypeScriptImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createTypeScriptImport"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createTypeScriptImport"));
        }
        ES6ImportPsiUtil.ImportType importType = info.getImportType();
        String name = info.getImportedName();
        Project project = place.getProject();
        StringBuilder builder = new StringBuilder("import ");
        if (importType == ES6ImportPsiUtil.ImportType.TS_REQUIRE_IMPORT) {
            builder.append(name).append(" = require(").append(moduleName).append(')');
        } else {
            builder.append(name).append(" = ").append(moduleName);
        }
        builder.append(JSCodeStyleSettings.getSemicolon(place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(project, builder.toString(), place);
        if (importNode == null || importNode.getElementType() != TypeScriptElementTypes.IMPORT_STATEMENT) {
            return null;
        }
        return (TypeScriptImportStatement)importNode.getPsi(TypeScriptImportStatement.class);
    }

    @Nullable
    public static ModuleInfo getExternalFileModuleName(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        return TypeScriptAutoImportUtil.getExternalFileModuleName(project, elementToImport, elementToImport.getContainingFile(), place);
    }

    @Nullable
    public static ModuleInfo getExternalFileModuleName(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile dstPsiFile, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (dstPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstPsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        Ref ref = Ref.create();
        String[] excludedNames = JSCodeStyleSettings.getSettings(place).getBlacklistImports();
        TypeScriptAutoImportUtil.processExternalFileModuleNames(project, elementToImport, dstPsiFile, place, (Processor<ModuleInfo>)((Processor)info -> {
            if (info.isValid() && (excludedNames.length == 0 || !ArrayUtil.contains((String)info.getModuleName(), (String[])excludedNames))) {
                ref.set(info);
                return false;
            }
            return true;
        }));
        return (ModuleInfo)ref.get();
    }

    public static void processExternalFileModuleNames(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile dstPsiFile, @NotNull PsiElement place, @NotNull Processor<ModuleInfo> processor) {
        ModuleInfo mappings;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (dstPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstPsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        PsiFile placePsiFile = place.getContainingFile();
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile dstFile = dstPsiFile.getVirtualFile();
        if (!TypeScriptAutoImportUtil.processModuleNameUsingNodeModules(project, dstFile, placePsiFile, elementToImport, processor)) {
            return;
        }
        TypeScriptConfig configFile = TypeScriptConfigUtil.getConfigForPsiFile(placePsiFile);
        if (configFile != null && (mappings = TypeScriptAutoImportUtil.getModuleNameUsingPathMappings(project, configFile, placePsiFile, dstFile, elementToImport)) != null && !processor.process((Object)mappings)) {
            return;
        }
        ModuleInfo moduleInfo = TypeScriptAutoImportUtil.getExternalModuleNameForFile(project, configFile, placeFile, placePsiFile, dstFile, (PsiElement)elementToImport, true);
        if (moduleInfo != null) {
            processor.process((Object)moduleInfo);
        }
    }

    @Nullable
    public static ModuleInfo getExternalModuleNameForFile(@NotNull Project project, @Nullable TypeScriptConfig configFile, @NotNull VirtualFile placeFile, @NotNull PsiFile placePsiFile, @NotNull VirtualFile dstFile, @NotNull PsiElement context, boolean checkNodeResolution) {
        String externalModuleName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleNameForFile"));
        }
        VirtualFile pathFile = dstFile.getParent();
        VirtualFile resultDest = null;
        if (checkNodeResolution && TypeScriptAutoImportUtil.useNodeResolution(project, configFile) && !Objects.equals(placeFile.getParent(), dstFile.getParent()) && context instanceof JSQualifiedNamedElement) {
            resultDest = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, placePsiFile, (JSQualifiedNamedElement)context, false);
        }
        if (resultDest == null) {
            pathFile = dstFile;
            resultDest = dstFile;
        }
        if (JSCodeStyleSettings.isUseAbsolutePath(context)) {
            VirtualFile rootFile = null;
            if (configFile != null && TypeScriptConfigService.Provider.isConfigInclude(project, pathFile, configFile)) {
                rootFile = configFile.getBaseUrl() != null ? configFile.getBaseUrl() : configFile.getConfigFile().getParent();
            }
            if (rootFile == null) {
                rootFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(placeFile, true);
            }
            if (rootFile != null) {
                String path = VfsUtil.getPath(rootFile, (VirtualFile)pathFile, (char)'/');
                if (path == null) {
                    return new ModuleInfo(VfsUtil.getPath((VirtualFile)rootFile, (VirtualFile)dstFile, (char)'/'), dstFile, dstFile, context);
                }
                return new ModuleInfo(path, resultDest, pathFile, context);
            }
        }
        if ((externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)pathFile, (char)'/')) == null) {
            externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)dstFile, (char)'/');
            if (externalModuleName == null) {
                return null;
            }
            pathFile = dstFile;
            resultDest = dstFile;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(File.separator)) {
            externalModuleName = "./" + externalModuleName;
        }
        return new ModuleInfo(externalModuleName, resultDest, pathFile, context);
    }

    private static boolean useNodeResolution(@NotNull Project project, @Nullable TypeScriptConfig config) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "useNodeResolution"));
        }
        if (!TypeScriptCodeStyleSettings.isUseNodeResolution(project)) {
            return false;
        }
        if (config == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = config.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == config.getModule();
    }

    public static ModuleInfo getModuleNameUsingPathMappings(@NotNull Project project, @NotNull TypeScriptConfig file, @NotNull PsiFile placePsiFile, @NotNull VirtualFile dstFile, @NotNull JSQualifiedNamedElement elementToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        VirtualFile baseUrl = file.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        ModuleInfo currentMapping = null;
        for (JSModulePathSubstitution substitution : file.getPaths()) {
            String pattern = substitution.getPattern();
            if (StringUtil.isEmpty((String)pattern)) continue;
            for (String mapping : substitution.getMappings()) {
                ModuleInfo possibleMapping;
                if (StringUtil.isEmpty((String)mapping) || (possibleMapping = TypeScriptAutoImportUtil.getModuleNameForMapping(project, baseUrl, dstFile, pattern, mapping, placePsiFile, elementToImport)) == null || !TypeScriptAutoImportUtil.shouldUseNewMapping(currentMapping, possibleMapping)) continue;
                currentMapping = possibleMapping;
            }
        }
        return currentMapping;
    }

    private static boolean shouldUseNewMapping(@Nullable ModuleInfo oldMapping, @NotNull ModuleInfo newMapping) {
        if (newMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "shouldUseNewMapping"));
        }
        if (oldMapping == null) {
            return true;
        }
        return newMapping.getPath().length() > oldMapping.getPath().length();
    }

    @Nullable
    private static ModuleInfo getModuleNameForMapping(@NotNull Project project, @NotNull VirtualFile baseUrl, @NotNull VirtualFile dstFile, @NotNull String pattern, @NotNull String mapping, @NotNull PsiFile placePsiFile, @NotNull JSQualifiedNamedElement elementToImport) {
        boolean hasSeparatorInFirstPart;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        mapping = FileUtil.toSystemIndependentName((String)mapping);
        int starIndex = mapping.indexOf("*");
        if (pattern.length() < 2) {
            return null;
        }
        if (starIndex < 0) {
            VirtualFile pathFile = TypeScriptAutoImportUtil.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile == null) {
                return null;
            }
            VirtualFile file = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, placePsiFile, elementToImport, true);
            return file == null ? null : new ModuleInfo(pattern, file, pathFile, (PsiElement)elementToImport);
        }
        String firstPart = mapping.substring(0, starIndex);
        int separatorIndex = firstPart.lastIndexOf(47);
        VirtualFile startDirectory = baseUrl;
        boolean bl = hasSeparatorInFirstPart = separatorIndex >= 0;
        if (hasSeparatorInFirstPart) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, firstPart.substring(0, separatorIndex));
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = TypeScriptAutoImportUtil.collectParents(dstFile, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        String partOfString = mapping.substring(hasSeparatorInFirstPart ? separatorIndex : 0);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file;
            String stringToCheckPattern = VfsUtil.getPath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/');
            if (StringUtil.isEmpty((String)stringToCheckPattern)) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString);
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((hasSeparatorInFirstPart ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, placePsiFile, elementToImport, false)) == null) continue;
            return new ModuleInfo(pattern.replace("*", (CharSequence)matchedStar.second), file, pathFile, (PsiElement)elementToImport);
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, VirtualFile startDirectory) {
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            if (startDirectory.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
            }
            return list;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
        }
        return arrayList;
    }

    private static VirtualFile checkSymbolAndGetFile(Project project, @NotNull VirtualFile dstFile, @NotNull VirtualFile pathFile, @NotNull PsiFile placePsiFile, @NotNull JSQualifiedNamedElement elementToImport, boolean checkNested) {
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (pathFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolAndGetFile"));
        }
        if (pathFile.isDirectory()) {
            VirtualFile possibleFile = TypeScriptAutoImportUtil.resolveAsNpmPackage(project, pathFile);
            if (possibleFile == null) {
                return null;
            }
            pathFile = possibleFile;
        }
        if ((!checkNested || TypeScriptAutoImportUtil.isFromNestedDirectory(pathFile, dstFile)) && (pathFile.equals(elementToImport.getContainingFile().getVirtualFile()) || TypeScriptAutoImportUtil.checkSymbolInFile(project, pathFile, elementToImport, placePsiFile))) {
            return pathFile;
        }
        return null;
    }

    private static VirtualFile resolveAsNpmPackage(@NotNull Project project, @NotNull VirtualFile pathFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "resolveAsNpmPackage"));
        }
        if (pathFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "resolveAsNpmPackage"));
        }
        return JSExactFileReference.resolveForNpmPackages(pathFile, new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project), false);
    }

    private static boolean isFromNestedDirectory(VirtualFile pathFile, VirtualFile dstFile) {
        if (pathFile.equals(dstFile)) {
            return true;
        }
        if (!pathFile.isDirectory()) {
            pathFile = pathFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)pathFile, (VirtualFile)dstFile, (boolean)false);
    }

    private static VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getPossibleFileWithExtension"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getPossibleFileWithExtension"));
        }
        if (JSFileReference.findExtension(mapping, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    public static boolean processModuleNameUsingNodeModules(@NotNull Project project, @NotNull VirtualFile dstFile, @NotNull PsiFile placePsiFile, @NotNull JSQualifiedNamedElement elementToImport, @NotNull Processor<ModuleInfo> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        Pair<VirtualFile, VirtualFile> libraryDirectory = TypeScriptAutoImportUtil.findParentLibraryDirectory(project, dstFile, NODE_MODULES);
        if (libraryDirectory == null) {
            return true;
        }
        VirtualFile moduleDirectory = (VirtualFile)libraryDirectory.first;
        VirtualFile directoryToCalcModuleName = TypeScriptAutoImportUtil.getDirectoryToCalcModuleNameInNodeModules(placePsiFile, moduleDirectory);
        if (directoryToCalcModuleName == null) {
            return true;
        }
        ArrayList elements = ContainerUtil.newArrayList(TypeScriptAutoImportUtil.collectParents(dstFile, moduleDirectory));
        elements.add(moduleDirectory);
        List virtualFiles = ContainerUtil.reverse((List)elements);
        for (VirtualFile file : virtualFiles) {
            VirtualFile candidate;
            if (file.equals(dstFile) || (candidate = TypeScriptAutoImportUtil.checkSymbolAndGetFile(project, dstFile, file, placePsiFile, elementToImport, false)) == null || !TypeScriptUtil.isDefinitionFile(candidate) || processor.process((Object)new ModuleInfo(VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)file, (char)'/'), candidate, file, (PsiElement)elementToImport))) continue;
            return false;
        }
        if (!moduleDirectory.equals(dstFile.getParent())) {
            for (VirtualFile candidate : moduleDirectory.getChildren()) {
                String path;
                ModuleInfo moduleInfo;
                if (candidate.isDirectory() || !TypeScriptUtil.isDefinitionFile(candidate) || !TypeScriptAutoImportUtil.checkSymbolInFile(project, candidate, elementToImport, placePsiFile) || processor.process((Object)(moduleInfo = new ModuleInfo(path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)candidate, (char)'/'), candidate, candidate, (PsiElement)elementToImport)))) continue;
                return false;
            }
        }
        ModuleInfo moduleInfo = new ModuleInfo(VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)dstFile, (char)'/'), dstFile, dstFile, (PsiElement)elementToImport);
        return processor.process((Object)moduleInfo);
    }

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile fileToCheck, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (fileToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToCheck", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        PsiFile possiblePsiFile = PsiManager.getInstance((Project)project).findFile(fileToCheck);
        if (!(possiblePsiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)possiblePsiFile;
        return TypeScriptAutoImportUtil.checkSymbolInModule(elementToImport, placePsiFile, (JSElement)file);
    }

    public static boolean checkSymbolInModule(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile, @NotNull JSElement module) {
        ResolveResult[] results;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        String name = elementToImport.getQualifiedName();
        if (name == null) {
            return false;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)placePsiFile, name, true);
        TypeScriptQualifiedItemProcessor<ResolveResultSink> processor = new TypeScriptQualifiedItemProcessor<ResolveResultSink>(sink, placePsiFile);
        ES6PsiUtil.processExportDeclarationInScope(module, processor, ResolveState.initial(), (PsiElement)placePsiFile);
        for (ResolveResult result : results = sink.getResultsAsResolveResults()) {
            PsiElement element;
            if (!result.isValidResult() || (element = result.getElement()) == null || !element.isEquivalentTo((PsiElement)elementToImport)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile getDirectoryToCalcModuleNameInNodeModules(@NotNull PsiFile placePsiFile, VirtualFile moduleDirectory) {
        VirtualFile parentOfNodeModules;
        VirtualFile directoryToCalcModuleName;
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getDirectoryToCalcModuleNameInNodeModules"));
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile current = moduleDirectory;
        VirtualFile nodeModulesDirectory = null;
        Object object = directoryToCalcModuleName = "@types".equals(current.getName()) ? current : null;
        while (current != null) {
            if ((current = current.getParent()) == null) continue;
            String name = current.getName();
            if ("@types".equals(name)) {
                directoryToCalcModuleName = current;
                continue;
            }
            if (!"node_modules".equals(current.getName())) continue;
            nodeModulesDirectory = current;
            break;
        }
        if (nodeModulesDirectory == null) {
            return null;
        }
        if (directoryToCalcModuleName == null) {
            directoryToCalcModuleName = nodeModulesDirectory;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)(parentOfNodeModules = nodeModulesDirectory.getParent()), (VirtualFile)placeFile, (boolean)true)) {
            return null;
        }
        return directoryToCalcModuleName;
    }

    @Nullable
    public static Pair<VirtualFile, VirtualFile> findParentLibraryDirectory(@NotNull Project project, @NotNull VirtualFile dstFile, String[] directories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findParentLibraryDirectory"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findParentLibraryDirectory"));
        }
        VirtualFile prevDirectory = null;
        VirtualFile prevDirectoryWithPackageJson = null;
        Object[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null; currentDirectory = currentDirectory.getParent()) {
            if (ArrayUtil.contains((String)currentDirectory.getName(), (String[])directories)) {
                VirtualFile module = prevDirectoryWithPackageJson == null ? prevDirectory : prevDirectoryWithPackageJson;
                return Pair.create(module, (Object)currentDirectory);
            }
            if (ArrayUtil.contains((Object)currentDirectory, (Object[])stopDirs)) break;
            if (null != currentDirectory.findChild("package.json")) {
                prevDirectoryWithPackageJson = currentDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    @Nullable
    static JSExportAssignment getExportAssignment(@Nullable PsiElement module) {
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren(module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NotNull
    static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        ASTNode lBrace;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        PsiElement currentChild = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            currentChild = lBrace.getPsi().getNextSibling();
        }
        PsiElement lastImport = null;
        while (currentChild != null) {
            if (currentChild instanceof TypeScriptImportStatement || currentChild instanceof ES6ImportDeclaration || JSPsiImplUtils.isUseStrictStatement(currentChild)) {
                lastImport = currentChild;
            } else if (lastImport == null && !(currentChild instanceof PsiWhiteSpace) && !(currentChild instanceof PsiComment)) break;
            currentChild = currentChild.getNextSibling();
        }
        Pair pair = Pair.create((Object)(lastImport != null ? 1 : 0), (Object)(lastImport != null ? lastImport : currentChild));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        return pair;
    }

    @Nullable
    static ES6ImportDeclaration findExistingES6ImportByFromModules(@NotNull PsiElement[] declarations, @Nullable PsiElement module, boolean checkAcceptable) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingES6ImportByFromModules"));
        }
        if (module == null) {
            return null;
        }
        for (PsiElement declaration : declarations) {
            Collection resolvedElements;
            ES6ImportDeclaration es6Import;
            ES6FromClause clause;
            if (!(declaration instanceof ES6ImportDeclaration) || (clause = (es6Import = (ES6ImportDeclaration)declaration).getFromClause()) == null || !(resolvedElements = clause.resolveReferencedElements()).contains(module) || checkAcceptable && !TypeScriptAutoImportUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration)) continue;
            return es6Import;
        }
        return null;
    }

    @Nullable
    static ES6ImportDeclaration findExistingES6ImportByFromText(PsiElement[] declarations, @NotNull String moduleName, boolean checkAcceptable) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingES6ImportByFromText"));
        }
        String unquotedModule = StringUtil.unquoteString((String)moduleName);
        if (!unquotedModule.isEmpty()) {
            for (PsiElement declaration : declarations) {
                String fromText;
                if (!(declaration instanceof ES6ImportDeclaration) || !unquotedModule.equals(fromText = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)((ES6ImportDeclaration)declaration))) || checkAcceptable && !TypeScriptAutoImportUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration)) continue;
                return (ES6ImportDeclaration)declaration;
            }
        }
        return null;
    }

    private static boolean isAcceptableAsExistingImport(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAcceptableAsExistingImport"));
        }
        if (declaration.getImportSpecifiers().length > 0) {
            return true;
        }
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        if (bindings.length != 1) {
            return bindings.length == 0;
        }
        ES6ImportedBinding binding = bindings[0];
        return !binding.isNamespaceImport();
    }

    static boolean tryToAddImportToExistingDeclaration(@NotNull ES6ImportDeclaration declaration, @NotNull String name, @NotNull ES6ImportPsiUtil.ImportType type) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "tryToAddImportToExistingDeclaration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "tryToAddImportToExistingDeclaration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "tryToAddImportToExistingDeclaration"));
        }
        if (type == ES6ImportPsiUtil.ImportType.BARE) {
            return true;
        }
        ES6ImportPsiUtil.ImportedElementCreateInfo info = new ES6ImportPsiUtil.ImportedElementCreateInfo(name, type);
        return ES6ImportPsiUtil.insertImportSpecifier(declaration, info) != null;
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }

    public static class JSReferencePlaceInfo {
        @NotNull
        private final PsiElement place;
        @NotNull
        private final PsiElement parent;
        @NotNull
        private final VirtualFile file;
        @Nullable
        private final PsiElement container;
        private final boolean isStrictTypeContext;

        public JSReferencePlaceInfo(@NotNull PsiElement place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$JSReferencePlaceInfo", "<init>"));
            }
            this.place = place;
            this.parent = place.getParent();
            this.file = place.getContainingFile().getOriginalFile().getVirtualFile();
            this.container = ES6PsiUtil.getExportScope(place);
            this.isStrictTypeContext = place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place);
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$JSReferencePlaceInfo", "getFile"));
            }
            return virtualFile;
        }
    }

    public static class ModuleInfo {
        @NotNull
        private final String myQuotedPath;
        @Nullable
        private final VirtualFile myModule;
        @NotNull
        private final VirtualFile myResolveFile;
        @NotNull
        private final String myModuleName;

        public ModuleInfo(@Nullable String path, @Nullable VirtualFile module, @NotNull VirtualFile pathFile, @NotNull PsiElement context) {
            if (pathFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "<init>"));
            }
            String externalModuleName = StringUtil.trimEnd((String)StringUtil.notNullize((String)path), (String)".d.ts");
            externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".ts");
            this.myModuleName = externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".tsx");
            this.myQuotedPath = ES6ImportPsiUtil.wrapWithQuotesFromSettings(this.myModuleName, context);
            this.myModule = module;
            this.myResolveFile = pathFile;
        }

        public boolean isValid() {
            return this.getModule() != null && !StringUtil.isEmpty((String)this.myModuleName);
        }

        @NotNull
        public String getModuleName() {
            String string = this.myModuleName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "getModuleName"));
            }
            return string;
        }

        @NotNull
        public String getPath() {
            String string = this.myQuotedPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "getPath"));
            }
            return string;
        }

        @Nullable
        public VirtualFile getModule() {
            return this.myModule;
        }

        @NotNull
        public VirtualFile getPathFile() {
            VirtualFile virtualFile = this.myResolveFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$ModuleInfo", "getPathFile"));
            }
            return virtualFile;
        }

        public String toString() {
            return this.myQuotedPath;
        }
    }
}

