/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TypeScriptAutoImportOptionsProvider
implements AutoImportOptionsProvider {
    private JBCheckBox myShowImportPopup;
    private JPanel myPanel = new JPanel((LayoutManager)new GridLayoutManager(2, 1));

    public TypeScriptAutoImportOptionsProvider() {
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"typescript.language.simple.name", (Object[])new Object[0])));
        this.myShowImportPopup = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.show.import.popup", (Object[])new Object[0]));
        GridConstraints checkBoxConstants = new GridConstraints();
        checkBoxConstants.setAnchor(9);
        this.myPanel.add((Component)this.myShowImportPopup, checkBoxConstants);
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkText("Find more configuration options in ", "Code Style", "");
        label.addHyperlinkListener(e -> {
            Settings settings;
            DataContext context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
            if (context != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                Configurable configurable = settings.find("preferences.sourceCode.TypeScript");
                settings.select(configurable);
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(1);
        constraints.setAnchor(9);
        this.myPanel.add((Component)label, constraints);
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return settings.isShowTypeScriptAutoImport() != this.myShowImportPopup.isSelected();
    }

    public void apply() throws ConfigurationException {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        settings.setShowTypeScriptAutoImport(this.myShowImportPopup.isSelected());
    }

    public void reset() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        this.myShowImportPopup.setSelected(settings.isShowTypeScriptAutoImport());
    }

    public void disposeUIResources() {
    }
}

