/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfig {
    public static final String JSON_EXTENSION = ".json";
    @Deprecated
    public static final String OUT_PROPERTY = "out";
    public static final String FILES_PROPERTY = "files";
    public static final String DECLARATION_DIR_PROPERTY = "declarationDir";
    public static final String EXCLUDES_PROPERTY = "exclude";
    public static final String INCLUDES_PROPERTY = "include";
    public static final String COMPILER_OPTIONS_PROPERTY = "compilerOptions";
    public static final String COMPILE_ON_SAVE = "compileOnSave";
    public static final String INLINE_SOURCE_MAP = "inlineSourceMap";
    public static final String SOURCE_MAP = "sourceMap";
    public static final String REACT_NAMESPACE = "reactNamespace";
    public static final String EXTENDS = "extends";
    public static final String TS_CONFIG_JSON = "tsconfig.json";
    public static final String TARGET_OPTION = "target";
    public static final String OUT_DIR = "outDir";
    public static final String OUT_FILE = "outFile";
    public static final String PATHS = "paths";
    public static final String ROOT_DIRS = "rootDirs";
    public static final String BASE_URL = "baseUrl";
    public static final String MODULE_RESOLUTION = "moduleResolution";
    public static final String MODULE = "module";
    public static final String TYPES = "types";
    public static final String LIB = "lib";
    public static final String TYPE_ROOTS = "typeRoots";
    public static final String TYPES_MODULE = "@types";
    public static final String DEFAULT_TYPES_DIRECTORY = "node_modules/@types";
    public static final String MODULE_RESOLUTION_NODE = "node";
    public static final String MODULE_COMMON_JS = "commonjs";
    public static final Collection<String> DEFAULT_EXCLUDE_VALUES = ContainerUtil.newHashSet((Object[])JSLibraryUtil.LIBRARY_DIR_NAMES);
    public static final LanguageTarget DEFAULT_LANGUAGE_TARGET = LanguageTarget.ES5;

    public boolean accept(@NotNull VirtualFile var1);

    public boolean isDirectoryBased();

    @NotNull
    public VirtualFile getConfigFile();

    @NotNull
    public VirtualFile getConfigDirectory();

    @NotNull
    public Collection<JSModulePathSubstitution> getPaths();

    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs();

    @NotNull
    public LanguageTarget getLanguageTarget();

    @Nullable
    public VirtualFile getBaseUrl();

    @Nullable
    public String getOutDirectory();

    public boolean hasErrors();

    public boolean isCompileOnSave();

    public boolean isInlineSourceMap();

    public boolean isSourceMap();

    public boolean hasES6Lib();

    public Collection<String> getLibNames();

    @NotNull
    public Collection<VirtualFile> getTypeRoots();

    @NotNull
    public ModuleResolution getResolution();

    public Collection<String> getTypes();

    @NotNull
    public ModuleTarget getModule();

    public boolean isExcludedFile(@NotNull VirtualFile var1);

    public boolean isIncludedFile(@NotNull VirtualFile var1);

    public boolean isFromFileList(@NotNull VirtualFile var1);

    public boolean isFromRootDirs(@NotNull VirtualFile var1);

    public boolean isIncludeTypesFile(@NotNull VirtualFile var1);

    @Nullable
    public String getRawCompilerOption(@NotNull String var1);

    @Nullable
    public static TypeScriptConfig getConfig(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfig", "getConfig"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return TypeScriptConfigBase.getConfig(rawFile, ContainerUtil.newHashSet());
    }

    @NotNull
    public Collection<VirtualFile> getDependencies();

    public static enum ModuleTarget {
        COMMON_JS,
        OTHER;

    }

    public static enum ModuleResolution {
        NODE,
        OTHER;

    }

    public static enum LanguageTarget {
        ES5,
        ES6,
        ES3;

    }
}

