/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ConstantIfStatementFix();
    }

    protected static void replaceStatementOrRemove(JSStatement statement, @NonNls String newStatement) throws IncorrectOperationException {
        JSLanguageDialect javascript = JSUtils.getDialect(statement.getContainingFile());
        ASTNode fromText = StringUtil.isEmptyOrSpaces((String)newStatement) ? null : JSChangeUtil.createJSTreeFromText(statement.getProject(), newStatement, javascript);
        PsiElement element = fromText != null ? fromText.getPsi() : null;
        ASTNode parentNode = statement.getParent().getNode();
        ASTNode node = statement.getNode();
        if (element != null) {
            parentNode.addChildren(fromText, null, node);
        }
        parentNode.removeChild(node);
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        public void visitJSIfStatement(JSIfStatement statement) {
            super.visitJSIfStatement(statement);
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            JSStatement thenBranch = statement.getThen();
            if (thenBranch == null) {
                return;
            }
            if (ControlFlowUtils.isTrue(condition) || ControlFlowUtils.isFalse(condition)) {
                this.registerStatementError((JSStatement)statement, new Object[0]);
            }
        }
    }

    public static class ConstantIfStatementFix
    extends InspectionJSFix {
        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection$ConstantIfStatementFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            JSIfStatement statement = (JSIfStatement)ifKeyword.getParent();
            assert (statement != null);
            ConstantIfStatementFix.simplifyConstantIf(statement);
        }

        public static void simplifyConstantIf(@NotNull JSIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection$ConstantIfStatementFix", "simplifyConstantIf"));
            }
            JSStatement thenBranch = statement.getThen();
            JSStatement elseBranch = statement.getElse();
            JSExpression condition = statement.getCondition();
            if (ControlFlowUtils.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement);
                } else {
                    ConstantIfStatementFix.deleteElement((PsiElement)statement);
                }
            } else {
                ConstantIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement);
            }
        }

        private static void replaceStatementWithUnwrapping(JSStatement branch, JSIfStatement statement) throws IncorrectOperationException {
            String branchText = branch.getText();
            if (branchText.startsWith("{") && branchText.endsWith("}")) {
                branchText = branchText.substring(1, branchText.length() - 1).trim();
            }
            ConstantIfStatementJSInspection.replaceStatementOrRemove((JSStatement)statement, branchText);
        }
    }
}

