/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ForLoopThatDoesntUseLoopVariableJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        boolean condition = (Boolean)args[0];
        boolean update = (Boolean)args[1];
        if (condition && update) {
            String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.problem.descriptor.both.condition.and.update", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection", "buildErrorString"));
            }
            return string;
        }
        if (condition) {
            String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.problem.descriptor.condition", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.problem.descriptor.update", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopThatDoesntUseLoopVariableVisitor();
    }

    private static class UseVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private boolean used = false;

        private UseVisitor(JSVariable var) {
            this.variable = var;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection$UseVisitor", "visitElement"));
            }
            if (!this.used) {
                super.visitElement(element);
            }
        }

        public void visitJSReferenceExpression(@NotNull JSReferenceExpression ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection$UseVisitor", "visitJSReferenceExpression"));
            }
            if (this.used) {
                return;
            }
            super.visitJSReferenceExpression(ref);
            PsiElement resolvedElement = ref.resolve();
            if (this.variable.equals(resolvedElement)) {
                this.used = true;
            }
        }

        public boolean isUsed() {
            return this.used;
        }
    }

    private static class ForLoopThatDoesntUseLoopVariableVisitor
    extends BaseInspectionVisitor {
        private ForLoopThatDoesntUseLoopVariableVisitor() {
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection$ForLoopThatDoesntUseLoopVariableVisitor", "visitJSForStatement"));
            }
            super.visitJSForStatement(statement);
            if (!JSInheritedLanguagesHelper.forConditionShouldUseVariables((PsiElement)statement)) {
                return;
            }
            if (ForLoopThatDoesntUseLoopVariableVisitor.conditionUsesInitializer(statement)) {
                if (!ForLoopThatDoesntUseLoopVariableVisitor.updateUsesInitializer(statement)) {
                    this.registerStatementError((JSStatement)statement, Boolean.FALSE, Boolean.TRUE);
                }
            } else if (ForLoopThatDoesntUseLoopVariableVisitor.updateUsesInitializer(statement)) {
                this.registerStatementError((JSStatement)statement, Boolean.TRUE, Boolean.FALSE);
            } else {
                this.registerStatementError((JSStatement)statement, Boolean.TRUE, Boolean.TRUE);
            }
        }

        private static boolean conditionUsesInitializer(JSForStatement statement) {
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return true;
            }
            JSVarStatement initialization = statement.getVarDeclaration();
            if (initialization == null) {
                return true;
            }
            JSVariable[] variables = initialization.getVariables();
            boolean result = false;
            for (JSVariable v : variables) {
                result |= ForLoopThatDoesntUseLoopVariableVisitor.expressionUsesVariable(condition, v);
            }
            return result;
        }

        private static boolean updateUsesInitializer(JSForStatement statement) {
            JSExpression update = statement.getUpdate();
            if (update == null) {
                return true;
            }
            JSVarStatement initialization = statement.getVarDeclaration();
            if (initialization == null) {
                return true;
            }
            JSVariable[] variables = initialization.getVariables();
            boolean result = false;
            for (JSVariable v : variables) {
                result |= ForLoopThatDoesntUseLoopVariableVisitor.expressionUsesVariable(update, v);
            }
            return result;
        }

        private static boolean expressionUsesVariable(JSExpression expression, JSVariable localVar) {
            UseVisitor useVisitor = new UseVisitor(localVar);
            expression.accept((PsiElementVisitor)useVisitor);
            return useVisitor.isUsed();
        }
    }
}

