/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.functionmetrics.CyclomaticComplexityVisitor;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityJSInspection
extends FunctionMetricsInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("overly.complex.function.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.FUNCTIONMETRICS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("function.complexity.limit.parameter", new Object[0]);
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
        PsiElement lastChild = function.getLastChild();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int coupling = visitor.getComplexity();
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.ref.is.overly.complex.cyclomatic.complexity.error.string", coupling);
        }
        return InspectionJSBundle.message("anonymous.function.is.overly.complex.cyclomatic.complexity.error.string", coupling);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityJSInspection$Visitor", "visitJSFunctionDeclaration"));
            }
            PsiElement lastChild = function.getLastChild();
            if (!(lastChild instanceof JSBlockStatement)) {
                return;
            }
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            lastChild.accept((PsiElementVisitor)visitor);
            int complexity = visitor.getComplexity();
            if (complexity <= CyclomaticComplexityJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }
    }
}

