/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import org.jetbrains.annotations.NotNull;

class CyclomaticComplexityVisitor
extends JSRecursiveElementVisitor {
    private int complexity = 1;

    CyclomaticComplexityVisitor() {
    }

    public void visitJSElement(JSElement jsElement) {
        int oldComplexity = 0;
        if (jsElement instanceof JSFunction) {
            oldComplexity = this.complexity;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.complexity = oldComplexity;
        }
    }

    public void visitJSForStatement(@NotNull JSForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor", "visitJSForStatement"));
        }
        super.visitJSForStatement(statement);
        ++this.complexity;
    }

    public void visitJSForInStatement(@NotNull JSForInStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor", "visitJSForInStatement"));
        }
        super.visitJSForInStatement(statement);
        ++this.complexity;
    }

    public void visitJSIfStatement(@NotNull JSIfStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor", "visitJSIfStatement"));
        }
        super.visitJSIfStatement(statement);
        ++this.complexity;
    }

    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor", "visitJSDoWhileStatement"));
        }
        super.visitJSDoWhileStatement(statement);
        ++this.complexity;
    }

    public void visitJSConditionalExpression(JSConditionalExpression expression) {
        super.visitJSConditionalExpression(expression);
        ++this.complexity;
    }

    public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
        JSCaseClause[] caseClauses;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor", "visitJSSwitchStatement"));
        }
        super.visitJSSwitchStatement(statement);
        for (JSCaseClause clause : caseClauses = statement.getCaseClauses()) {
            JSStatement[] statements = clause.getStatements();
            if (statements == null || statements.length == 0) continue;
            ++this.complexity;
        }
    }

    public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor", "visitJSWhileStatement"));
        }
        super.visitJSWhileStatement(statement);
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }
}

