/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.freemarker.psi.files.FtlSyntaxHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataHighlighterWrapper;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private FtlDirectiveStyle myStyle;
    @Nullable
    private final Project myProject;
    @Nullable
    private final VirtualFile myVirtualFile;

    public FtlEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/freemarker/psi/files/FtlEditorHighlighter", "<init>"));
        }
        super((SyntaxHighlighter)new FtlSyntaxHighlighter(), colors);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.registerLayer((IElementType)FtlElementTypes.TEMPLATE_TEXT, new LayerDescriptor((SyntaxHighlighter)new TemplateDataHighlighterWrapper(FtlEditorHighlighter.getHighlighter(project, virtualFile)), ""));
        if (virtualFile != null) {
            this.myStyle = FtlLexer.guessDirectiveStyle(virtualFile, project);
        }
    }

    protected boolean updateLayers() {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid() || this.myVirtualFile.getFileType() != FtlFileType.INSTANCE) {
            return false;
        }
        FtlDirectiveStyle style = FtlLexer.guessDirectiveStyle(this.myVirtualFile, this.myProject);
        if (style != this.myStyle) {
            this.myStyle = style;
            ((FtlLexer)this.getLexer()).clearStyle();
            return true;
        }
        return false;
    }

    @NotNull
    private static SyntaxHighlighter getHighlighter(Project project, VirtualFile virtualFile) {
        LanguageFileType type = project == null || virtualFile == null ? null : FtlFileViewProvider.getTemplateDataLanguage(virtualFile, project).getAssociatedFileType();
        LanguageFileType fileType = type == null ? FileTypes.PLAIN_TEXT : type;
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, (VirtualFile)virtualFile);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlEditorHighlighter", "getHighlighter"));
        }
        return syntaxHighlighter;
    }
}

